package org.xbib.helianthus.client;

import static java.util.Objects.requireNonNull;

import org.xbib.helianthus.common.Request;
import org.xbib.helianthus.common.Response;

/**
 * Decorates a {@link Client}.
 */
public abstract class DecoratingClient<T_I extends Request, T_O extends Response,
        R_I extends Request, R_O extends Response> implements Client<R_I, R_O> {

    private final Client<? super T_I, ? extends T_O> delegate;

    /**
     * Creates a new instance that decorates the specified {@link Client}.
     */
    protected DecoratingClient(Client<? super T_I, ? extends T_O> delegate) {
        this.delegate = requireNonNull(delegate, "delegate");
    }

    /**
     * Returns the {@link Client} being decorated.
     */
    @SuppressWarnings("unchecked")
    protected final <T extends Client<? super T_I, ? extends T_O>> T delegate() {
        return (T) delegate;
    }

    @Override
    public String toString() {
        final String simpleName = getClass().getSimpleName();
        final String name = simpleName.isEmpty() ? getClass().getName() : simpleName;
        return name + '(' + delegate + ')';
    }
}
