package org.xbib.helianthus.client.http;

import io.netty.channel.ChannelHandlerContext;
import org.xbib.helianthus.internal.IdleTimeoutHandler;

final class HttpClientIdleTimeoutHandler extends IdleTimeoutHandler {

    HttpClientIdleTimeoutHandler(long idleTimeoutMillis) {
        super("client", idleTimeoutMillis);
    }

    @Override
    protected boolean hasRequestsInProgress(ChannelHandlerContext ctx) {
        return HttpSession.get(ctx.channel()).hasUnfinishedResponses();
    }
}
