/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ThreadFactory;
import java.util.function.Function;
import java.util.function.Supplier;
import org.xbib.helianthus.client.AbstractClientFactory;
import org.xbib.helianthus.client.SessionOptions;
import org.xbib.helianthus.common.RequestContext;
import org.xbib.helianthus.common.util.NativeLibraries;

public abstract class NonDecoratingClientFactory
extends AbstractClientFactory {
    private final EventLoopGroup eventLoopGroup;
    private final boolean closeEventLoopGroup;
    private final SessionOptions options;
    private final Bootstrap baseBootstrap;
    private final Supplier<EventLoop> eventLoopSupplier = () -> (EventLoop)RequestContext.mapCurrent(RequestContext::eventLoop, () -> this.eventLoopGroup().next());

    protected NonDecoratingClientFactory(SessionOptions options, boolean useDaemonThreads) {
        this(options, type -> {
            switch (type) {
                case NIO: {
                    return new DefaultThreadFactory("org.xbib.helianthus.client.nio", useDaemonThreads);
                }
                case EPOLL: {
                    return new DefaultThreadFactory("org.xbib.helianthus.client.epoll", useDaemonThreads);
                }
            }
            throw new Error();
        });
    }

    private NonDecoratingClientFactory(SessionOptions options, Function<TransportType, ThreadFactory> threadFactoryFactory) {
        Objects.requireNonNull(options, "options");
        Objects.requireNonNull(threadFactoryFactory, "threadFactoryFactory");
        Bootstrap baseBootstrap = new Bootstrap();
        baseBootstrap.channel(NonDecoratingClientFactory.channelType());
        baseBootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)NonDecoratingClientFactory.safeLongToInt(options.connectTimeoutMillis()));
        baseBootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)true);
        Optional<EventLoopGroup> eventLoopOption = options.eventLoopGroup();
        if (eventLoopOption.isPresent()) {
            this.eventLoopGroup = eventLoopOption.get();
            this.closeEventLoopGroup = false;
        } else {
            this.eventLoopGroup = NonDecoratingClientFactory.createGroup(threadFactoryFactory);
            this.closeEventLoopGroup = true;
        }
        this.baseBootstrap = baseBootstrap;
        this.options = options;
    }

    private static Class<? extends SocketChannel> channelType() {
        return NativeLibraries.isEpollAvailable() ? EpollSocketChannel.class : NioSocketChannel.class;
    }

    private static Class<? extends DatagramChannel> datagramChannelType() {
        return NativeLibraries.isEpollAvailable() ? EpollDatagramChannel.class : NioDatagramChannel.class;
    }

    private static EventLoopGroup createGroup(Function<TransportType, ThreadFactory> threadFactoryFactory) {
        return NativeLibraries.isEpollAvailable() ? new EpollEventLoopGroup(0, threadFactoryFactory.apply(TransportType.EPOLL)) : new NioEventLoopGroup(0, threadFactoryFactory.apply(TransportType.NIO));
    }

    @Override
    public final EventLoopGroup eventLoopGroup() {
        return this.eventLoopGroup;
    }

    @Override
    public final SessionOptions options() {
        return this.options;
    }

    public Bootstrap newBootstrap() {
        return this.baseBootstrap.clone();
    }

    @Override
    public final Supplier<EventLoop> eventLoopSupplier() {
        return this.eventLoopSupplier;
    }

    @Override
    public void close() {
        if (this.closeEventLoopGroup) {
            this.eventLoopGroup.shutdownGracefully().syncUninterruptibly();
        }
    }

    private static int safeLongToInt(long longValue) {
        return (int)Math.min(Math.max(longValue, Integer.MIN_VALUE), Integer.MAX_VALUE);
    }

    private static enum TransportType {
        NIO,
        EPOLL;

    }
}

