/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.client;

import io.netty.channel.EventLoopGroup;
import io.netty.resolver.AddressResolverGroup;
import io.netty.util.ConstantPool;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Function;
import javax.net.ssl.TrustManagerFactory;
import org.xbib.helianthus.client.SessionOptionValue;
import org.xbib.helianthus.client.pool.KeyedChannelPoolHandler;
import org.xbib.helianthus.client.pool.PoolKey;
import org.xbib.helianthus.common.util.AbstractOption;

public class SessionOption<T>
extends AbstractOption<T> {
    private static final ConstantPool pool = new ConstantPool(){

        protected SessionOption<Object> newConstant(int id, String name) {
            return new SessionOption<Object>(id, name);
        }
    };
    public static final SessionOption<Duration> CONNECT_TIMEOUT = SessionOption.valueOf("CONNECT_TIMEOUT");
    public static final SessionOption<Duration> IDLE_TIMEOUT = SessionOption.valueOf("IDLE_TIMEOUT");
    public static final SessionOption<Integer> MAX_CONCURRENCY = SessionOption.valueOf("MAX_CONCURRENCY");
    public static final SessionOption<TrustManagerFactory> TRUST_MANAGER_FACTORY = SessionOption.valueOf("TRUST_MANAGER_FACTORY");
    public static final SessionOption<AddressResolverGroup<? extends InetSocketAddress>> ADDRESS_RESOLVER_GROUP = SessionOption.valueOf("ADDRESS_RESOLVER_GROUP");
    public static final SessionOption<EventLoopGroup> EVENT_LOOP_GROUP = SessionOption.valueOf("EVENT_LOOP_GROUP");
    public static final SessionOption<Function<KeyedChannelPoolHandler<PoolKey>, KeyedChannelPoolHandler<PoolKey>>> POOL_HANDLER_DECORATOR = SessionOption.valueOf("POOL_HANDLER_DECORATOR");
    public static final SessionOption<Boolean> USE_HTTP2_PREFACE = SessionOption.valueOf("USE_HTTP2_PREFACE");

    private SessionOption(int id, String name) {
        super(id, name);
    }

    public static <T> SessionOption<T> valueOf(String name) {
        return (SessionOption)pool.valueOf(name);
    }

    public SessionOptionValue<T> newValue(T value) {
        Objects.requireNonNull(value, "value");
        return new SessionOptionValue<T>(this, value);
    }
}

