/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.client.http;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpStatusClass;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.ReferenceCountUtil;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xbib.helianthus.client.http.HttpResponseDecoder;
import org.xbib.helianthus.common.ContentTooLargeException;
import org.xbib.helianthus.common.ProtocolViolationException;
import org.xbib.helianthus.common.http.HttpData;
import org.xbib.helianthus.common.http.HttpObject;
import org.xbib.helianthus.internal.http.HelianthusHttpUtil;

final class Http1ResponseDecoder
extends HttpResponseDecoder
implements ChannelInboundHandler {
    private static final Logger logger = Logger.getLogger(Http1ResponseDecoder.class.getName());
    private HttpResponseDecoder.HttpResponseWrapper res;
    private int resId = 1;
    private State state = State.NEED_HEADERS;

    Http1ResponseDecoder(Channel channel) {
        super(channel);
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        ctx.fireChannelRegistered();
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        ctx.fireChannelUnregistered();
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        ctx.fireChannelActive();
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        ctx.fireChannelInactive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (!(msg instanceof io.netty.handler.codec.http.HttpObject)) {
            ctx.fireChannelRead(msg);
            return;
        }
        try {
            switch (this.state) {
                case NEED_HEADERS: {
                    HttpResponseDecoder.HttpResponseWrapper res;
                    if (!(msg instanceof HttpResponse)) {
                        this.failWithUnexpectedMessageType(ctx, msg);
                        return;
                    }
                    HttpResponse nettyRes = (HttpResponse)msg;
                    DecoderResult decoderResult = nettyRes.decoderResult();
                    if (!decoderResult.isSuccess()) {
                        this.fail(ctx, (Throwable)new ProtocolViolationException(decoderResult.cause()));
                        return;
                    }
                    if (!HttpUtil.isKeepAlive((HttpMessage)nettyRes)) {
                        this.disconnectWhenFinished();
                    }
                    if ((res = this.getResponse(this.resId)) == null) {
                        throw new IllegalStateException();
                    }
                    this.res = res;
                    this.state = nettyRes.status().codeClass() == HttpStatusClass.INFORMATIONAL ? State.NEED_INFORMATIONAL_DATA : State.NEED_DATA_OR_TRAILING_HEADERS;
                    res.scheduleTimeout(ctx);
                    res.write((HttpObject)HelianthusHttpUtil.toHelianthus((HttpResponse)nettyRes));
                    return;
                }
                case NEED_INFORMATIONAL_DATA: {
                    if (msg instanceof LastHttpContent) {
                        this.state = State.NEED_HEADERS;
                        return;
                    }
                    this.failWithUnexpectedMessageType(ctx, msg);
                    return;
                }
                case NEED_DATA_OR_TRAILING_HEADERS: {
                    HttpResponseDecoder.HttpResponseWrapper res;
                    if (!(msg instanceof HttpContent)) {
                        this.failWithUnexpectedMessageType(ctx, msg);
                        return;
                    }
                    HttpContent content = (HttpContent)msg;
                    DecoderResult decoderResult = content.decoderResult();
                    if (!decoderResult.isSuccess()) {
                        this.fail(ctx, (Throwable)new ProtocolViolationException(decoderResult.cause()));
                        return;
                    }
                    ByteBuf data = content.content();
                    int dataLength = data.readableBytes();
                    if (dataLength > 0) {
                        long maxContentLength = this.res.maxContentLength();
                        if (maxContentLength > 0L && this.res.writtenBytes() > maxContentLength - (long)dataLength) {
                            this.fail(ctx, (Throwable)ContentTooLargeException.get());
                            return;
                        }
                        this.res.write((HttpObject)HttpData.of((ByteBuf)data));
                    }
                    if (!(msg instanceof LastHttpContent)) return;
                    if (this.res != (res = this.removeResponse(this.resId++))) {
                        throw new IllegalStateException();
                    }
                    this.res = null;
                    this.state = State.NEED_HEADERS;
                    HttpHeaders trailingHeaders = ((LastHttpContent)msg).trailingHeaders();
                    if (!trailingHeaders.isEmpty()) {
                        res.write(HelianthusHttpUtil.toHelianthus((HttpHeaders)trailingHeaders));
                    }
                    res.close();
                    if (!this.needsToDisconnect()) return;
                    ctx.close();
                    return;
                }
            }
            return;
        }
        finally {
            ReferenceCountUtil.release((Object)msg);
        }
    }

    private void failWithUnexpectedMessageType(ChannelHandlerContext ctx, Object msg) {
        this.fail(ctx, (Throwable)new ProtocolViolationException("unexpected message type: " + msg.getClass().getName()));
    }

    private void fail(ChannelHandlerContext ctx, Throwable cause) {
        this.state = State.DISCARD;
        HttpResponseDecoder.HttpResponseWrapper res = this.res;
        this.res = null;
        if (res != null) {
            res.close(cause);
        } else {
            logger.log(Level.WARNING, "Unexpected exception:", cause);
        }
        ctx.close();
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.fireChannelReadComplete();
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        ctx.fireUserEventTriggered(evt);
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        ctx.fireChannelWritabilityChanged();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        ctx.fireExceptionCaught(cause);
    }

    private static enum State {
        NEED_HEADERS,
        NEED_INFORMATIONAL_DATA,
        NEED_DATA_OR_TRAILING_HEADERS,
        DISCARD;

    }
}

