/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.client.http;

import java.nio.charset.Charset;
import org.xbib.helianthus.client.ClientBuilderParams;
import org.xbib.helianthus.common.http.AggregatedHttpMessage;
import org.xbib.helianthus.common.http.HttpData;
import org.xbib.helianthus.common.http.HttpHeaders;
import org.xbib.helianthus.common.http.HttpMethod;
import org.xbib.helianthus.common.http.HttpRequest;
import org.xbib.helianthus.common.http.HttpResponse;

public interface HttpClient
extends ClientBuilderParams {
    public HttpResponse execute(HttpRequest var1);

    public HttpResponse execute(AggregatedHttpMessage var1);

    default public HttpResponse execute(HttpHeaders headers) {
        return this.execute(AggregatedHttpMessage.of((HttpHeaders)headers));
    }

    default public HttpResponse execute(HttpHeaders headers, HttpData content) {
        return this.execute(AggregatedHttpMessage.of((HttpHeaders)headers, (HttpData)content));
    }

    default public HttpResponse execute(HttpHeaders headers, byte[] content) {
        return this.execute(AggregatedHttpMessage.of((HttpHeaders)headers, (HttpData)HttpData.of((byte[])content)));
    }

    default public HttpResponse execute(HttpHeaders headers, String content) {
        return this.execute(AggregatedHttpMessage.of((HttpHeaders)headers, (HttpData)HttpData.ofUtf8((String)content)));
    }

    default public HttpResponse execute(HttpHeaders headers, String content, Charset charset) {
        return this.execute(AggregatedHttpMessage.of((HttpHeaders)headers, (HttpData)HttpData.of((Charset)charset, (String)content)));
    }

    default public HttpResponse options(String path) {
        return this.execute(HttpHeaders.of((HttpMethod)HttpMethod.OPTIONS, (String)path));
    }

    default public HttpResponse get(String path) {
        return this.execute(HttpHeaders.of((HttpMethod)HttpMethod.GET, (String)path));
    }

    default public HttpResponse head(String path) {
        return this.execute(HttpHeaders.of((HttpMethod)HttpMethod.HEAD, (String)path));
    }

    default public HttpResponse post(String path, HttpData content) {
        return this.execute(HttpHeaders.of((HttpMethod)HttpMethod.POST, (String)path), content);
    }

    default public HttpResponse post(String path, byte[] content) {
        return this.execute(HttpHeaders.of((HttpMethod)HttpMethod.POST, (String)path), content);
    }

    default public HttpResponse post(String path, String content) {
        return this.execute(HttpHeaders.of((HttpMethod)HttpMethod.POST, (String)path), HttpData.ofUtf8((String)content));
    }

    default public HttpResponse post(String path, String content, Charset charset) {
        return this.execute(HttpHeaders.of((HttpMethod)HttpMethod.POST, (String)path), content, charset);
    }

    default public HttpResponse put(String path, HttpData content) {
        return this.execute(HttpHeaders.of((HttpMethod)HttpMethod.PUT, (String)path), content);
    }

    default public HttpResponse put(String path, byte[] content) {
        return this.execute(HttpHeaders.of((HttpMethod)HttpMethod.PUT, (String)path), content);
    }

    default public HttpResponse put(String path, String content) {
        return this.execute(HttpHeaders.of((HttpMethod)HttpMethod.PUT, (String)path), HttpData.ofUtf8((String)content));
    }

    default public HttpResponse put(String path, String content, Charset charset) {
        return this.execute(HttpHeaders.of((HttpMethod)HttpMethod.PUT, (String)path), content, charset);
    }

    default public HttpResponse patch(String path, HttpData content) {
        return this.execute(HttpHeaders.of((HttpMethod)HttpMethod.PATCH, (String)path), content);
    }

    default public HttpResponse patch(String path, byte[] content) {
        return this.execute(HttpHeaders.of((HttpMethod)HttpMethod.PATCH, (String)path), content);
    }

    default public HttpResponse patch(String path, String content) {
        return this.execute(HttpHeaders.of((HttpMethod)HttpMethod.PATCH, (String)path), HttpData.ofUtf8((String)content));
    }

    default public HttpResponse patch(String path, String content, Charset charset) {
        return this.execute(HttpHeaders.of((HttpMethod)HttpMethod.PATCH, (String)path), content, charset);
    }

    default public HttpResponse delete(String path) {
        return this.execute(HttpHeaders.of((HttpMethod)HttpMethod.DELETE, (String)path));
    }

    default public HttpResponse trace(String path) {
        return this.execute(HttpHeaders.of((HttpMethod)HttpMethod.TRACE, (String)path));
    }
}

