/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.client.pool;

import io.netty.channel.Channel;
import io.netty.channel.EventLoop;
import io.netty.channel.pool.ChannelHealthChecker;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import java.util.Deque;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Function;
import org.xbib.helianthus.client.pool.KeyedChannelPool;
import org.xbib.helianthus.client.pool.KeyedChannelPoolHandler;
import org.xbib.helianthus.client.pool.KeyedChannelPoolUtil;
import org.xbib.helianthus.client.pool.SafeKeyedChannelPoolHandler;
import org.xbib.helianthus.common.util.Exceptions;

public class DefaultKeyedChannelPool<K>
implements KeyedChannelPool<K> {
    private static final IllegalStateException FULL_EXCEPTION = (IllegalStateException)Exceptions.clearTrace((Throwable)new IllegalStateException("ChannelPool full"));
    private static final IllegalStateException UNHEALTHY_NON_OFFERED_TO_POOL = (IllegalStateException)Exceptions.clearTrace((Throwable)new IllegalStateException("Channel is unhealthy; not offering it back to pool"));
    private final EventLoop eventLoop;
    private final Function<K, Future<Channel>> channelFactory;
    private final ChannelHealthChecker healthCheck;
    private final KeyedChannelPoolHandler<K> channelPoolHandler;
    private final boolean releaseHealthCheck;
    private final Map<K, Deque<Channel>> pool;

    public DefaultKeyedChannelPool(EventLoop eventLoop, Function<K, Future<Channel>> channelFactory, KeyedChannelPoolHandler<K> channelPoolHandler) {
        this(eventLoop, channelFactory, ChannelHealthChecker.ACTIVE, channelPoolHandler, true);
    }

    public DefaultKeyedChannelPool(EventLoop eventLoop, Function<K, Future<Channel>> channelFactory, ChannelHealthChecker healthCheck, KeyedChannelPoolHandler<K> channelPoolHandler) {
        this(eventLoop, channelFactory, healthCheck, channelPoolHandler, true);
    }

    public DefaultKeyedChannelPool(EventLoop eventLoop, Function<K, Future<Channel>> channelFactory, ChannelHealthChecker healthCheck, KeyedChannelPoolHandler<K> channelPoolHandler, boolean releaseHealthCheck) {
        this.eventLoop = Objects.requireNonNull(eventLoop, "eventLoop");
        this.channelFactory = Objects.requireNonNull(channelFactory, "channelFactory");
        this.healthCheck = Objects.requireNonNull(healthCheck, "healthCheck");
        this.channelPoolHandler = new SafeKeyedChannelPoolHandler<K>(Objects.requireNonNull(channelPoolHandler, "channelPoolHandler"));
        this.releaseHealthCheck = releaseHealthCheck;
        this.pool = new ConcurrentHashMap<K, Deque<Channel>>();
    }

    private static void closeChannel(Channel channel) {
        channel.attr(KeyedChannelPoolUtil.POOL).set(null);
        channel.close();
    }

    private static void closeAndFail(Channel channel, Throwable cause, Promise<?> promise) {
        DefaultKeyedChannelPool.closeChannel(channel);
        promise.setFailure(cause);
    }

    @Override
    public Future<Channel> acquire(K key) {
        return this.acquire(key, (Promise<Channel>)this.eventLoop.newPromise());
    }

    @Override
    public Future<Channel> acquire(K key, Promise<Channel> promise) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(promise, "promise");
        if (this.eventLoop.inEventLoop()) {
            this.acquireHealthyFromPoolOrNew(key, promise);
        } else {
            this.eventLoop.execute(() -> this.acquireHealthyFromPoolOrNew(key, promise));
        }
        return promise;
    }

    private Future<Channel> acquireHealthyFromPoolOrNew(K key, Promise<Channel> promise) {
        Channel ch;
        Deque<Channel> queue = this.pool.get(key);
        Channel channel = ch = queue == null ? null : queue.poll();
        if (ch == null) {
            Future<Channel> f = this.channelFactory.apply(key);
            if (f.isDone()) {
                this.notifyConnect(key, f, promise);
            } else {
                f.addListener(future -> this.notifyConnect(key, (Future<Channel>)future, promise));
            }
            return promise;
        }
        EventLoop loop = ch.eventLoop();
        if (loop.inEventLoop()) {
            this.doHealthCheck(key, ch, promise);
        } else {
            loop.execute(() -> this.doHealthCheck(key, ch, promise));
        }
        return promise;
    }

    private void notifyConnect(K key, Future<Channel> future, Promise<Channel> promise) {
        assert (future.isDone());
        try {
            if (future.isSuccess()) {
                Channel channel = (Channel)future.getNow();
                channel.attr(KeyedChannelPoolUtil.POOL).set((Object)this);
                this.channelPoolHandler.channelCreated(key, channel);
                channel.closeFuture().addListener(f -> this.channelPoolHandler.channelClosed(key, channel));
                promise.setSuccess((Object)channel);
            } else {
                promise.setFailure(future.cause());
            }
        }
        catch (Exception e) {
            promise.setFailure((Throwable)e);
        }
    }

    private void doHealthCheck(K key, Channel ch, Promise<Channel> promise) {
        assert (ch.eventLoop().inEventLoop());
        Future f = this.healthCheck.isHealthy(ch);
        if (f.isDone()) {
            this.notifyHealthCheck(key, (Future<Boolean>)f, ch, promise);
        } else {
            f.addListener((GenericFutureListener)((FutureListener)future -> this.notifyHealthCheck(key, (Future<Boolean>)future, ch, promise)));
        }
    }

    private void notifyHealthCheck(K key, Future<Boolean> future, Channel ch, Promise<Channel> promise) {
        assert (ch.eventLoop().inEventLoop());
        if (future.isSuccess()) {
            if (future.getNow() == Boolean.TRUE) {
                try {
                    ch.attr(KeyedChannelPoolUtil.POOL).set((Object)this);
                    this.channelPoolHandler.channelAcquired(key, ch);
                    promise.setSuccess((Object)ch);
                }
                catch (Throwable cause) {
                    DefaultKeyedChannelPool.closeAndFail(ch, cause, promise);
                }
            } else {
                DefaultKeyedChannelPool.closeChannel(ch);
                this.acquireHealthyFromPoolOrNew(key, promise);
            }
        } else {
            DefaultKeyedChannelPool.closeChannel(ch);
            this.acquireHealthyFromPoolOrNew(key, promise);
        }
    }

    @Override
    public Future<Void> release(K key, Channel channel) {
        return this.release(key, channel, (Promise<Void>)this.eventLoop.newPromise());
    }

    @Override
    public Future<Void> release(K key, Channel channel, Promise<Void> promise) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(channel, "channel");
        Objects.requireNonNull(promise, "promise");
        try {
            EventLoop loop = channel.eventLoop();
            if (loop.inEventLoop()) {
                this.doReleaseChannel(key, channel, promise);
            } else {
                loop.execute(() -> this.doReleaseChannel(key, channel, promise));
            }
        }
        catch (Throwable cause) {
            DefaultKeyedChannelPool.closeAndFail(channel, cause, promise);
        }
        return promise;
    }

    private void doReleaseChannel(K key, Channel channel, Promise<Void> promise) {
        assert (channel.eventLoop().inEventLoop());
        if (channel.attr(KeyedChannelPoolUtil.POOL).getAndSet(null) != this) {
            DefaultKeyedChannelPool.closeAndFail(channel, new IllegalArgumentException("Channel " + channel + " was not acquired from this ChannelPool"), promise);
        } else {
            try {
                if (this.releaseHealthCheck) {
                    this.doHealthCheckOnRelease(key, channel, promise);
                } else {
                    this.releaseAndOffer(key, channel, promise);
                }
            }
            catch (Throwable cause) {
                DefaultKeyedChannelPool.closeAndFail(channel, cause, promise);
            }
        }
    }

    private void doHealthCheckOnRelease(K key, Channel channel, Promise<Void> promise) throws Exception {
        Future f = this.healthCheck.isHealthy(channel);
        if (f.isDone()) {
            this.releaseAndOfferIfHealthy(key, channel, promise, (Future<Boolean>)f);
        } else {
            f.addListener(future -> this.releaseAndOfferIfHealthy(key, channel, promise, (Future<Boolean>)f));
        }
    }

    private void releaseAndOfferIfHealthy(K key, Channel channel, Promise<Void> promise, Future<Boolean> future) throws Exception {
        if (((Boolean)future.getNow()).booleanValue()) {
            this.releaseAndOffer(key, channel, promise);
        } else {
            this.channelPoolHandler.channelReleased(key, channel);
            DefaultKeyedChannelPool.closeAndFail(channel, UNHEALTHY_NON_OFFERED_TO_POOL, promise);
        }
    }

    private void releaseAndOffer(K key, Channel channel, Promise<Void> promise) throws Exception {
        if (this.offerChannel(key, channel)) {
            this.channelPoolHandler.channelReleased(key, channel);
            promise.setSuccess(null);
        } else {
            DefaultKeyedChannelPool.closeAndFail(channel, FULL_EXCEPTION, promise);
        }
    }

    protected Channel pollChannel(K key) {
        Channel ch;
        Deque<Channel> queue = this.pool.get(key);
        if (queue == null) {
            ch = null;
        } else {
            ch = queue.poll();
            if (queue.isEmpty()) {
                this.pool.remove(key);
            }
        }
        return ch;
    }

    protected boolean offerChannel(K key, Channel channel) {
        return this.pool.computeIfAbsent(key, k -> new ConcurrentLinkedDeque()).offer(channel);
    }

    @Override
    public void close() {
        this.pool.forEach((k, v) -> {
            Channel channel;
            while ((channel = this.pollChannel(k)) != null) {
                if (!channel.isOpen()) continue;
                channel.close();
            }
        });
    }
}

