/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.client.routing;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.xbib.helianthus.client.Endpoint;
import org.xbib.helianthus.client.routing.EndpointGroup;
import org.xbib.helianthus.client.routing.EndpointGroupException;
import org.xbib.helianthus.client.routing.EndpointSelectionStrategy;
import org.xbib.helianthus.client.routing.EndpointSelector;

public final class EndpointGroupRegistry {
    private static final Map<String, EndpointSelector> serverGroups = new ConcurrentHashMap<String, EndpointSelector>();

    private EndpointGroupRegistry() {
    }

    public static void register(String groupName, EndpointGroup endpointGroup, EndpointSelectionStrategy endpointSelectionStrategy) {
        Objects.requireNonNull(groupName, "groupName");
        Objects.requireNonNull(endpointGroup, "group");
        Objects.requireNonNull(endpointSelectionStrategy, "endpointSelectionStrategy");
        if (serverGroups.putIfAbsent(groupName, endpointSelectionStrategy.newSelector(endpointGroup)) != null) {
            throw new EndpointGroupException("A EndpointGroup with the same name exists: " + groupName);
        }
    }

    public static void replace(String groupName, EndpointGroup endpointGroup, EndpointSelectionStrategy endpointSelectionStrategy) {
        Objects.requireNonNull(groupName, "groupName");
        Objects.requireNonNull(endpointGroup, "group");
        Objects.requireNonNull(endpointSelectionStrategy, "endpointSelectionStrategy");
        if (serverGroups.replace(groupName, endpointSelectionStrategy.newSelector(endpointGroup)) == null) {
            throw new EndpointGroupException("non-existent EndpointGroup: " + groupName);
        }
    }

    public static EndpointSelector getNodeSelector(String groupName) {
        Objects.requireNonNull(groupName, "groupName");
        return serverGroups.get(groupName);
    }

    public static EndpointGroup get(String groupName) {
        Objects.requireNonNull(groupName, "groupName");
        EndpointSelector endpointSelector = serverGroups.get(groupName);
        if (endpointSelector == null) {
            return null;
        }
        return endpointSelector.group();
    }

    public static Endpoint selectNode(String groupName) {
        EndpointSelector endpointSelector = EndpointGroupRegistry.getNodeSelector(groupName);
        if (endpointSelector == null) {
            throw new EndpointGroupException("non-existent EndpointGroup: " + groupName);
        }
        return endpointSelector.select();
    }
}

