package org.xbib.helianthus.common.http;

import static java.util.Objects.requireNonNull;

import org.xbib.helianthus.common.stream.DefaultStreamMessage;

/**
 * Default {@link HttpRequest} implementation.
 */
public class DefaultHttpRequest
        extends DefaultStreamMessage<HttpObject> implements HttpRequest, HttpRequestWriter {

    private final HttpHeaders headers;
    private final boolean keepAlive;

    public DefaultHttpRequest() {
        this(new DefaultHttpHeaders());
    }

    public DefaultHttpRequest(HttpHeaders headers) {
        this(headers, true);
    }

    public DefaultHttpRequest(HttpMethod method, String path) {
        this(HttpHeaders.of(method, path));
    }

    public DefaultHttpRequest(HttpHeaders headers, boolean keepAlive) {
        this.headers = requireNonNull(headers, "headers");
        this.keepAlive = keepAlive;
    }

    @Override
    public HttpHeaders headers() {
        return headers;
    }

    @Override
    public boolean isKeepAlive() {
        return keepAlive;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DefaultHttpRequest:keepAlive=")
                .append(isKeepAlive())
                .append(",headers=")
                .append(headers());
        return sb.toString();
    }
}
