/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.common.http;

import java.util.Arrays;
import org.xbib.helianthus.common.http.HttpData;

final class DefaultHttpData
implements HttpData {
    private final byte[] data;
    private final int offset;
    private final int length;
    private final boolean endOfStream;

    DefaultHttpData(byte[] data, int offset, int length, boolean endOfStream) {
        this.data = data;
        this.offset = offset;
        this.length = length;
        this.endOfStream = endOfStream;
    }

    @Override
    public byte[] array() {
        return this.data;
    }

    @Override
    public int offset() {
        return this.offset;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public boolean isEndOfStream() {
        return this.endOfStream;
    }

    public int hashCode() {
        int end = this.offset + this.length;
        int hash = 1;
        for (int i = this.offset; i < end; ++i) {
            hash = hash * 31 + this.data[i];
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HttpData)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        HttpData that = (HttpData)obj;
        if (this.length() != that.length()) {
            return false;
        }
        int endOffset = this.offset + this.length;
        int i = this.offset;
        int j = that.offset();
        while (i < endOffset) {
            if (this.data[i] != this.data[j]) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("offset=").append(this.offset).append(",length=").append(this.length).append(",array=").append(Arrays.toString(this.data));
        return sb.toString();
    }
}

