/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.common.http;

import java.time.Instant;
import java.time.Year;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalField;
import java.util.Locale;
import java.util.Objects;

final class HeaderDateTimeFormat {
    private static final ZoneId GMT = ZoneId.of("GMT");
    private static final DateTimeFormatter format1 = HeaderDateTimeFormat.newFormat("E, dd MMM yyyy HH:mm:ss z");
    private static final DateTimeFormatter format2 = HeaderDateTimeFormat.newFormat("E, dd-MMM-yy HH:mm:ss z");
    private static final DateTimeFormatter format2a = new DateTimeFormatterBuilder().parseLenient().parseCaseInsensitive().appendPattern("E, dd-MMM-").appendValueReduced((TemporalField)ChronoField.YEAR, 2, 2, Year.now().getValue() - 80).appendPattern(" HH:mm:ss z").toFormatter(Locale.ENGLISH).withZone(GMT);
    private static final DateTimeFormatter format3 = HeaderDateTimeFormat.newFormat("E MMM d HH:mm:ss yyyy");

    private HeaderDateTimeFormat() {
    }

    private static DateTimeFormatter newFormat(String pattern) {
        return new DateTimeFormatterBuilder().parseLenient().parseCaseInsensitive().appendPattern(pattern).toFormatter(Locale.ENGLISH).withZone(GMT);
    }

    static Instant parse(String text) {
        Objects.requireNonNull(text);
        try {
            return HeaderDateTimeFormat.parse(format1, text);
        }
        catch (Exception e1) {
            try {
                return HeaderDateTimeFormat.parse(format2, text);
            }
            catch (Exception e2) {
                try {
                    return HeaderDateTimeFormat.parse(format2a, text);
                }
                catch (Exception e2a) {
                    try {
                        return HeaderDateTimeFormat.parse(format3, text);
                    }
                    catch (Exception e3) {
                        throw new IllegalArgumentException("not a date: " + text);
                    }
                }
            }
        }
    }

    private static Instant parse(DateTimeFormatter formatter, String text) {
        return formatter.parse((CharSequence)text, Instant::from);
    }

    static String format(long timeMillis) {
        return format1.format(Instant.ofEpochMilli(timeMillis));
    }
}

