/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.internal.http;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Stream;
import java.util.Objects;
import org.xbib.helianthus.common.http.HttpData;
import org.xbib.helianthus.common.http.HttpHeaders;
import org.xbib.helianthus.common.stream.ClosedPublisherException;
import org.xbib.helianthus.internal.http.HelianthusHttpUtil;
import org.xbib.helianthus.internal.http.HttpObjectEncoder;

public final class Http2ObjectEncoder
extends HttpObjectEncoder {
    private final Http2ConnectionEncoder encoder;

    public Http2ObjectEncoder(Http2ConnectionEncoder encoder) {
        this.encoder = Objects.requireNonNull(encoder, "encoder");
    }

    @Override
    protected ChannelFuture doWriteHeaders(ChannelHandlerContext ctx, int id, int streamId, HttpHeaders headers, boolean endStream) {
        ChannelFuture future = this.validateStream(ctx, streamId);
        if (future != null) {
            return future;
        }
        return this.encoder.writeHeaders(ctx, streamId, HelianthusHttpUtil.toNettyHttp2(headers), 0, endStream, ctx.newPromise());
    }

    @Override
    protected ChannelFuture doWriteData(ChannelHandlerContext ctx, int id, int streamId, HttpData data, boolean endStream) {
        ChannelFuture future = this.validateStream(ctx, streamId);
        if (future != null) {
            return future;
        }
        return this.encoder.writeData(ctx, streamId, Http2ObjectEncoder.toByteBuf(ctx, data), 0, endStream, ctx.newPromise());
    }

    @Override
    protected ChannelFuture doWriteReset(ChannelHandlerContext ctx, int id, int streamId, Http2Error error) {
        ChannelFuture future = this.validateStream(ctx, streamId);
        if (future != null) {
            return future;
        }
        return this.encoder.writeRstStream(ctx, streamId, error.code(), ctx.newPromise());
    }

    private ChannelFuture validateStream(ChannelHandlerContext ctx, int streamId) {
        block5: {
            block4: {
                Http2Stream stream = this.encoder.connection().stream(streamId);
                if (stream == null) break block4;
                switch (stream.state()) {
                    case RESERVED_LOCAL: 
                    case OPEN: 
                    case HALF_CLOSED_REMOTE: {
                        break block5;
                    }
                    default: {
                        return ctx.newFailedFuture((Throwable)ClosedPublisherException.get());
                    }
                }
            }
            if (this.encoder.connection().streamMayHaveExisted(streamId)) {
                return ctx.newFailedFuture((Throwable)ClosedPublisherException.get());
            }
        }
        return null;
    }

    @Override
    protected void doClose() {
    }
}

