/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.common;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Stream;
import org.xbib.helianthus.common.RequestContext;

final class RequestContextAwareFuture<T>
implements Future<T> {
    private final RequestContext context;
    private final Future<T> delegate;

    RequestContextAwareFuture(RequestContext context, Future<T> delegate) {
        this.context = context;
        this.delegate = delegate;
    }

    public boolean isSuccess() {
        return this.delegate.isSuccess();
    }

    public boolean isCancellable() {
        return this.delegate.isCancellable();
    }

    public Throwable cause() {
        return this.delegate.cause();
    }

    public Future<T> addListener(GenericFutureListener<? extends Future<? super T>> listener) {
        return this.delegate.addListener(this.context.makeContextAware(listener));
    }

    public Future<T> addListeners(GenericFutureListener<? extends Future<? super T>> ... listeners) {
        return this.delegate.addListeners((GenericFutureListener[])Stream.of(listeners).map(this.context::makeContextAware).toArray(GenericFutureListener[]::new));
    }

    public Future<T> removeListener(GenericFutureListener<? extends Future<? super T>> listener) {
        return this.delegate.removeListener(listener);
    }

    @SafeVarargs
    public final Future<T> removeListeners(GenericFutureListener<? extends Future<? super T>> ... listeners) {
        return this.delegate.removeListeners(listeners);
    }

    public Future<T> sync() throws InterruptedException {
        return this.delegate.sync();
    }

    public Future<T> syncUninterruptibly() {
        return this.delegate.syncUninterruptibly();
    }

    public Future<T> await() throws InterruptedException {
        return this.delegate.await();
    }

    public Future<T> awaitUninterruptibly() {
        return this.delegate.awaitUninterruptibly();
    }

    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.await(timeout, unit);
    }

    public boolean await(long timeoutMillis) throws InterruptedException {
        return this.delegate.await(timeoutMillis);
    }

    public boolean awaitUninterruptibly(long timeout, TimeUnit unit) {
        return this.delegate.awaitUninterruptibly(timeout, unit);
    }

    public boolean awaitUninterruptibly(long timeoutMillis) {
        return this.delegate.awaitUninterruptibly(timeoutMillis);
    }

    public T getNow() {
        return (T)this.delegate.getNow();
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.delegate.cancel(mayInterruptIfRunning);
    }

    public boolean isCancelled() {
        return this.delegate.isCancelled();
    }

    public boolean isDone() {
        return this.delegate.isDone();
    }

    public T get() throws InterruptedException, ExecutionException {
        return (T)this.delegate.get();
    }

    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (T)this.delegate.get(timeout, unit);
    }
}

