/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.common.logging;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.xbib.helianthus.common.RequestContext;
import org.xbib.helianthus.common.logging.RequestLog;
import org.xbib.helianthus.common.logging.RequestLogListener;
import org.xbib.helianthus.common.util.SafeCloseable;

public final class RequestLogListenerInvoker {
    private static final Logger logger = Logger.getLogger(RequestLogListenerInvoker.class.getName());

    private RequestLogListenerInvoker() {
    }

    public static void invokeOnRequestLog(RequestLogListener listener, RequestLog log) {
        try (SafeCloseable ignored = RequestContext.push(log.context());){
            listener.onRequestLog(log);
        }
        catch (Throwable e) {
            logger.log(Level.WARNING, "onRequestLog() failed with an exception:", e);
        }
    }
}

