/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.common.stream;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.xbib.helianthus.common.stream.StreamMessage;

public abstract class FilteredStreamMessage<T, U>
implements StreamMessage<U> {
    private final StreamMessage<T> delegate;

    protected FilteredStreamMessage(StreamMessage<T> delegate) {
        Objects.requireNonNull(delegate, "delegate");
        this.delegate = delegate;
    }

    protected abstract U filter(T var1);

    protected void beforeSubscribe(Subscriber<? super U> subscriber, Subscription subscription) {
    }

    protected void beforeComplete(Subscriber<? super U> subscriber) {
    }

    protected void beforeError(Subscriber<? super U> subscriber, Throwable cause) {
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public CompletableFuture<Void> closeFuture() {
        return this.delegate.closeFuture();
    }

    @Override
    public void subscribe(Subscriber<? super U> subscriber) {
        Objects.requireNonNull(subscriber, "subscriber");
        this.delegate.subscribe(new FilteringSubscriber(subscriber));
    }

    @Override
    public void subscribe(Subscriber<? super U> subscriber, Executor executor) {
        Objects.requireNonNull(subscriber, "subscriber");
        this.delegate.subscribe(new FilteringSubscriber(subscriber), executor);
    }

    @Override
    public void abort() {
        this.delegate.abort();
    }

    private final class FilteringSubscriber
    implements Subscriber<T> {
        private final Subscriber<? super U> delegate;

        FilteringSubscriber(Subscriber<? super U> delegate) {
            Objects.requireNonNull(delegate, "delegate");
            this.delegate = delegate;
        }

        public void onSubscribe(Subscription s) {
            FilteredStreamMessage.this.beforeSubscribe(this.delegate, s);
            this.delegate.onSubscribe(s);
        }

        public void onNext(T t) {
            this.delegate.onNext(FilteredStreamMessage.this.filter(t));
        }

        public void onError(Throwable t) {
            FilteredStreamMessage.this.beforeError(this.delegate, t);
            this.delegate.onError(t);
        }

        public void onComplete() {
            FilteredStreamMessage.this.beforeComplete(this.delegate);
            this.delegate.onComplete();
        }
    }
}

