/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.common.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;

public final class ExceptionFormatter {
    private ExceptionFormatter() {
    }

    public static void append(StringBuilder buf, Throwable t, int level, boolean details) {
        try {
            Method method;
            Throwable cause;
            if (t != null && t.getMessage() != null && t.getMessage().length() > 0) {
                if (details && level > 0) {
                    buf.append("\n\nCaused by\n");
                }
                buf.append(t.getMessage());
            }
            if (details) {
                if (t != null) {
                    if (t.getMessage() != null && t.getMessage().length() == 0) {
                        buf.append("\n\nCaused by ");
                    } else {
                        buf.append("\n\n");
                    }
                }
                StringWriter sw = new StringWriter();
                if (t != null) {
                    t.printStackTrace(new PrintWriter(sw));
                }
                buf.append(sw.toString());
            }
            if (t != null && (cause = (Throwable)(method = t.getClass().getMethod("getCause", new Class[0])).invoke((Object)t, new Object[]{null})) != null) {
                ExceptionFormatter.append(buf, cause, level + 1, details);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static String format(Throwable t) {
        StringBuilder sb = new StringBuilder();
        ExceptionFormatter.append(sb, t, 0, true);
        return sb.toString();
    }
}

