/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.common.util;

import io.netty.channel.epoll.Epoll;
import io.netty.handler.ssl.OpenSsl;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;

public final class NativeLibraries {
    private static final Logger logger = Logger.getLogger(NativeLibraries.class.getName());
    private static final AtomicBoolean reported = new AtomicBoolean();
    private static final boolean USE_EPOLL = !"false".equals(System.getProperty("org.xbib.helianthus.useEpoll", "true"));
    private static final boolean USE_OPENSSL = !"false".equals(System.getProperty("org.xbib.helianthus.useOpenSsl", "true"));

    private NativeLibraries() {
    }

    public static void report() {
        if (!reported.compareAndSet(false, true)) {
            return;
        }
        if (USE_EPOLL) {
            logger.info("/dev/epoll: " + (Epoll.isAvailable() ? "yes" : "no (" + NativeLibraries.filterCause(Epoll.unavailabilityCause()) + ')'));
        } else {
            logger.info("/dev/epoll: disabled");
        }
        if (USE_OPENSSL) {
            logger.info("OpenSSL: " + (OpenSsl.isAvailable() ? "yes (" + OpenSsl.versionString() + ", " + OpenSsl.version() + ')' : "no (" + NativeLibraries.filterCause(OpenSsl.unavailabilityCause()) + ')'));
        } else {
            logger.info("OpenSSL: disabled");
        }
    }

    private static Throwable filterCause(Throwable cause) {
        if (cause instanceof ExceptionInInitializerError) {
            return cause.getCause();
        }
        return cause;
    }

    public static boolean isEpollAvailable() {
        NativeLibraries.report();
        return USE_EPOLL && Epoll.isAvailable();
    }

    public static boolean isOpenSslAvailable() {
        NativeLibraries.report();
        return USE_OPENSSL && OpenSsl.isAvailable();
    }
}

