package org.xbib.helianthus.common.http;

import org.xbib.helianthus.common.stream.FilteredStreamMessage;

/**
 * An {@link HttpResponse} that filters objects as they are published. The filtering
 * will happen from an I/O thread, meaning the order of the filtering will match the
 * order that the {@code delegate} processes the objects in.
 */
public abstract class FilteredHttpResponse
        extends FilteredStreamMessage<HttpObject, HttpObject> implements HttpResponse {

    /**
     * Creates a new {@link FilteredHttpResponse} that filters objects published by {@code delegate}
     * before passing to a subscriber.
     */
    protected FilteredHttpResponse(HttpResponse delegate) {
        super(delegate);
    }
}
