/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.common;

import io.netty.channel.EventLoop;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.xbib.helianthus.common.RequestContext;
import org.xbib.helianthus.common.RequestContextAwareCompletableFuture;
import org.xbib.helianthus.common.util.SafeCloseable;

public abstract class AbstractRequestContext
implements RequestContext {
    @Override
    public final EventLoop contextAwareEventLoop() {
        return RequestContext.super.contextAwareEventLoop();
    }

    @Override
    public final Executor makeContextAware(Executor executor) {
        return RequestContext.super.makeContextAware(executor);
    }

    @Override
    public final <T> Callable<T> makeContextAware(Callable<T> callable) {
        return () -> {
            try (SafeCloseable ignored = this.propagateContextIfNotPresent();){
                Object v = callable.call();
                return v;
            }
        };
    }

    @Override
    public final Runnable makeContextAware(Runnable runnable) {
        return () -> {
            try (SafeCloseable ignored = this.propagateContextIfNotPresent();){
                runnable.run();
            }
        };
    }

    @Override
    public final <T, R> Function<T, R> makeContextAware(Function<T, R> function) {
        return t -> {
            try (SafeCloseable ignored = this.propagateContextIfNotPresent();){
                Object r = function.apply(t);
                return r;
            }
        };
    }

    @Override
    public final <T, U, V> BiFunction<T, U, V> makeContextAware(BiFunction<T, U, V> function) {
        return (t, u) -> {
            try (SafeCloseable ignored = this.propagateContextIfNotPresent();){
                Object r = function.apply(t, u);
                return r;
            }
        };
    }

    @Override
    public final <T> Consumer<T> makeContextAware(Consumer<T> action) {
        return t -> {
            try (SafeCloseable ignored = this.propagateContextIfNotPresent();){
                action.accept(t);
            }
        };
    }

    @Override
    public final <T, U> BiConsumer<T, U> makeContextAware(BiConsumer<T, U> action) {
        return (t, u) -> {
            try (SafeCloseable ignored = this.propagateContextIfNotPresent();){
                action.accept(t, u);
            }
        };
    }

    @Override
    public final <T extends Future<?>> GenericFutureListener<T> makeContextAware(GenericFutureListener<T> listener) {
        return future -> this.invokeOperationComplete(listener, future);
    }

    @Override
    public final <T> CompletionStage<T> makeContextAware(CompletionStage<T> stage) {
        RequestContextAwareCompletableFuture future = new RequestContextAwareCompletableFuture(this);
        stage.whenComplete((result, cause) -> {
            try (SafeCloseable ignored = this.propagateContextIfNotPresent();){
                if (cause != null) {
                    future.completeExceptionally((Throwable)cause);
                } else {
                    future.complete(result);
                }
            }
        });
        return future;
    }

    @Override
    public final <T> CompletableFuture<T> makeContextAware(CompletableFuture<T> future) {
        return RequestContext.super.makeContextAware(future);
    }

    private <T extends Future<?>> void invokeOperationComplete(GenericFutureListener<T> listener, T future) throws Exception {
        try (SafeCloseable ignored = this.propagateContextIfNotPresent();){
            listener.operationComplete(future);
        }
    }

    private SafeCloseable propagateContextIfNotPresent() {
        return RequestContext.mapCurrent(currentContext -> {
            if (currentContext != this) {
                throw new IllegalStateException("Trying to call object made with makeContextAware or object on executor made with makeContextAware with context " + this + ", but context is currently set to " + currentContext + ". This means the callback was passed from one invocation to another which is not allowed. Make sure you are not saving callbacks into shared state.");
            }
            return () -> {};
        }, () -> RequestContext.push(this, true));
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }
}

