/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.common;

import io.netty.channel.Channel;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.net.ssl.SSLSession;
import org.xbib.helianthus.common.AbstractRequestContext;
import org.xbib.helianthus.common.SessionProtocol;
import org.xbib.helianthus.internal.DefaultAttributeMap;

public abstract class NonWrappingRequestContext
extends AbstractRequestContext {
    private final DefaultAttributeMap attrs = new DefaultAttributeMap();
    private final SessionProtocol sessionProtocol;
    private final String method;
    private final String path;
    private final Object request;
    private List<Runnable> onEnterCallbacks;
    private List<Runnable> onExitCallbacks;

    protected NonWrappingRequestContext(SessionProtocol sessionProtocol, String method, String path, Object request) {
        this.sessionProtocol = sessionProtocol;
        this.method = method;
        this.path = path;
        this.request = request;
    }

    @Override
    public final SessionProtocol sessionProtocol() {
        return this.sessionProtocol;
    }

    protected abstract Channel channel();

    @Override
    public <A extends SocketAddress> A remoteAddress() {
        Channel ch = this.channel();
        return (A)(ch != null ? ch.remoteAddress() : null);
    }

    @Override
    public <A extends SocketAddress> A localAddress() {
        Channel ch = this.channel();
        return (A)(ch != null ? ch.localAddress() : null);
    }

    @Override
    public SSLSession sslSession() {
        Channel ch = this.channel();
        if (ch == null) {
            return null;
        }
        SslHandler sslHandler = (SslHandler)ch.pipeline().get(SslHandler.class);
        return sslHandler != null ? sslHandler.engine().getSession() : null;
    }

    @Override
    public final String method() {
        return this.method;
    }

    @Override
    public final String path() {
        return this.path;
    }

    @Override
    public final <T> T request() {
        return (T)this.request;
    }

    public <T> Attribute<T> attr(AttributeKey<T> key) {
        return this.attrs.attr(key);
    }

    public <T> boolean hasAttr(AttributeKey<T> key) {
        return this.attrs.hasAttr(key);
    }

    @Override
    public Iterator<Attribute<?>> attrs() {
        return this.attrs.attrs();
    }

    @Override
    public final void onEnter(Runnable callback) {
        if (this.onEnterCallbacks == null) {
            this.onEnterCallbacks = new ArrayList<Runnable>(4);
        }
        this.onEnterCallbacks.add(callback);
    }

    @Override
    public final void onExit(Runnable callback) {
        if (this.onExitCallbacks == null) {
            this.onExitCallbacks = new ArrayList<Runnable>(4);
        }
        this.onExitCallbacks.add(callback);
    }

    @Override
    public void invokeOnEnterCallbacks() {
        List<Runnable> onEnterCallbacks = this.onEnterCallbacks;
        if (onEnterCallbacks != null) {
            onEnterCallbacks.forEach(Runnable::run);
        }
    }

    @Override
    public void invokeOnExitCallbacks() {
        List<Runnable> onExitCallbacks = this.onExitCallbacks;
        if (onExitCallbacks != null) {
            onExitCallbacks.forEach(Runnable::run);
        }
    }
}

