/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.common;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.xbib.helianthus.common.RequestContext;

class RequestContextAwareExecutorService
implements ExecutorService {
    private final RequestContext context;
    private final ExecutorService delegate;

    RequestContextAwareExecutorService(RequestContext context, ExecutorService delegate) {
        this.context = context;
        this.delegate = delegate;
    }

    final RequestContext context() {
        return this.context;
    }

    ExecutorService delegate() {
        return this.delegate;
    }

    @Override
    public final void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public final List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.delegate.submit(this.context.makeContextAware(task));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.delegate.submit(this.context.makeContextAware(task), result);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.delegate.submit(this.context.makeContextAware(task));
    }

    @Override
    public final boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public final boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public final boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }

    @Override
    public final <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.delegate.invokeAll(this.makeContextAware(tasks));
    }

    @Override
    public final <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.invokeAll(this.makeContextAware(tasks), timeout, unit);
    }

    @Override
    public final <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.delegate.invokeAny(this.makeContextAware(tasks));
    }

    @Override
    public final <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.delegate.invokeAny(this.makeContextAware(tasks), timeout, unit);
    }

    @Override
    public final void execute(Runnable command) {
        this.delegate.execute(this.context.makeContextAware(command));
    }

    private <T> Collection<? extends Callable<T>> makeContextAware(Collection<? extends Callable<T>> tasks) {
        return tasks.stream().map(this.context::makeContextAware).collect(Collectors.toList());
    }
}

