/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.common.util;

import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.xbib.helianthus.common.util.AbstractOption;
import org.xbib.helianthus.common.util.AbstractOptionValue;

public abstract class AbstractOptions {
    protected Map<AbstractOption<Object>, AbstractOptionValue<AbstractOption<Object>, Object>> valueMap;

    @SafeVarargs
    protected <T extends AbstractOptionValue<?, ?>> AbstractOptions(Function<T, T> valueFilter, T ... values) {
        Objects.requireNonNull(valueFilter, "valueFilter");
        Objects.requireNonNull(values, "values");
        this.valueMap = new IdentityHashMap<AbstractOption<Object>, AbstractOptionValue<AbstractOption<Object>, Object>>();
        this.putAll(valueFilter, Stream.of(values));
    }

    protected <T extends AbstractOptionValue<?, ?>> AbstractOptions(Function<T, T> valueFilter, Iterable<T> values) {
        Objects.requireNonNull(valueFilter, "valueFilter");
        Objects.requireNonNull(values, "values");
        this.valueMap = new IdentityHashMap<AbstractOption<Object>, AbstractOptionValue<AbstractOption<Object>, Object>>();
        this.putAll(valueFilter, StreamSupport.stream(values.spliterator(), false));
    }

    @SafeVarargs
    protected <T extends AbstractOptionValue<?, ?>> AbstractOptions(Function<T, T> valueFilter, AbstractOptions baseOptions, T ... values) {
        Objects.requireNonNull(baseOptions, "baseOptions");
        Objects.requireNonNull(valueFilter, "valueFilter");
        Objects.requireNonNull(values, "values");
        this.valueMap = new IdentityHashMap<AbstractOption<Object>, AbstractOptionValue<AbstractOption<Object>, Object>>(baseOptions.valueMap);
        this.putAll(valueFilter, Stream.of(values));
    }

    protected <T extends AbstractOptionValue<?, ?>> AbstractOptions(Function<T, T> valueFilter, AbstractOptions baseOptions, Iterable<T> values) {
        Objects.requireNonNull(baseOptions, "baseOptions");
        Objects.requireNonNull(valueFilter, "valueFilter");
        Objects.requireNonNull(values, "values");
        this.valueMap = new IdentityHashMap<AbstractOption<Object>, AbstractOptionValue<AbstractOption<Object>, Object>>(baseOptions.valueMap);
        this.putAll(valueFilter, StreamSupport.stream(values.spliterator(), false));
    }

    protected <T extends AbstractOptionValue<?, ?>> AbstractOptions(AbstractOptions baseOptions, AbstractOptions options) {
        Objects.requireNonNull(baseOptions, "baseOptions");
        Objects.requireNonNull(options, "options");
        this.valueMap = new IdentityHashMap<AbstractOption<Object>, AbstractOptionValue<AbstractOption<Object>, Object>>(baseOptions.valueMap);
        this.valueMap.putAll(options.valueMap);
    }

    static String toString(Collection<?> values) {
        return "OptionValues{" + values + '}';
    }

    private <T extends AbstractOptionValue<?, ?>> void putAll(Function<T, T> valueFilter, Stream<T> values) {
        values.map(valueFilter).forEach(v -> this.valueMap.put((AbstractOption<Object>)((Object)((Object)v.option())), (AbstractOptionValue<AbstractOption<Object>, Object>)v));
    }

    protected <O extends AbstractOption<V>, V> Optional<V> get0(AbstractOption<V> option) {
        AbstractOptionValue<AbstractOption<Object>, Object> optionValue = this.valueMap.get(option);
        return optionValue == null ? Optional.empty() : Optional.of(optionValue.value());
    }

    protected <O extends AbstractOption<V>, V> V getOrElse0(O option, V defaultValue) {
        return this.get0(option).orElse(defaultValue);
    }

    protected <K, V> Map<K, V> asMap0() {
        return Collections.unmodifiableMap(this.valueMap);
    }

    public String toString() {
        return AbstractOptions.toString(this.asMap0().values());
    }
}

