package org.xbib.helianthus.common;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class MimeTypeParams {

    private static final Pattern PARAM_PATTERN = Pattern.compile(
            "\\s*;\\s*([^=\\s]+)\\s*=\\s*(?:([^\"][^;]*)|\"((?:[^\\\\\"]|\\\\.)*)\")");

    private MimeTypeParams() {
    }

    static String find(String params, String name) {
        assert name != null;
        if (params == null) {
            return null;
        }

        final Matcher m = PARAM_PATTERN.matcher(params);
        while (m.find()) {
            final String matchedName = m.group(1);
            final String unquotedValue = m.group(2);
            final String quotedValue = m.group(3);
            if (name.equals(matchedName)) {
                return unquotedValue != null ? unquotedValue : unquote(quotedValue);
            }
        }

        return null;
    }

    private static String unquote(String value) {
        final int length = value.length();
        final StringBuilder buf = new StringBuilder(length);

        boolean escaped = false;
        for (int i = 0; i < length; i++) {
            final char c = value.charAt(i);
            if (escaped) {
                buf.append(c);
                escaped = false;
            } else if (c != '\\') {
                buf.append(c);
            } else {
                escaped = true;
            }
        }

        return buf.toString();
    }
}
