package org.xbib.helianthus.common.http;

import java.util.Arrays;

final class DefaultHttpData implements HttpData {

    static final HttpData EMPTY_DATA = new DefaultHttpData(new byte[0], 0, 0);

    private final byte[] data;
    private final int offset;
    private final int length;

    DefaultHttpData(byte[] data, int offset, int length) {
        this.data = data;
        this.offset = offset;
        this.length = length;
    }

    @Override
    public byte[] array() {
        return data;
    }

    @Override
    public int offset() {
        return offset;
    }

    @Override
    public int length() {
        return length;
    }

    @Override
    public int hashCode() {
        final int end = offset + length;
        int hash = 1;
        for (int i = offset; i < end; i++) {
            hash = hash * 31 + data[i];
        }
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof HttpData)) {
            return false;
        }

        if (this == obj) {
            return true;
        }

        final HttpData that = (HttpData) obj;
        if (length() != that.length()) {
            return false;
        }

        final int endOffset = offset + length;
        for (int i = offset, j = that.offset(); i < endOffset; i++, j++) {
            if (data[i] != data[j]) {
                return false;
            }
        }

        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("offset=").append(offset)
                .append(",length=").append(length)
                .append(",array=").append(Arrays.toString(data));
        return sb.toString();
    }
}
