package org.xbib.helianthus.common.http;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;

final class HttpResponseAggregator extends HttpMessageAggregator {

    private List<HttpHeaders> informationals;
    private HttpHeaders headers;
    private HttpHeaders trailingHeaders;

    HttpResponseAggregator(CompletableFuture<AggregatedHttpMessage> future) {
        super(future);
        trailingHeaders = HttpHeaders.EMPTY_HEADERS;
    }

    @Override
    public void onNext(HttpObject o) {
        if (o instanceof HttpHeaders) {
            final HttpHeaders headers = (HttpHeaders) o;
            if (headers.status().codeClass() == HttpStatusClass.INFORMATIONAL) {
                if (informationals == null) {
                    informationals = new ArrayList<>(2);
                }
                informationals.add(headers);
            } else if (this.headers == null) {
                this.headers = headers;
            } else {
                trailingHeaders = headers;
            }
        } else {
            add((HttpData) o);
        }
    }

    @Override
    public void onError(Throwable t) {
        clear();
        future().completeExceptionally(t);
    }

    @Override
    protected void doClear() {
        headers = null;
        trailingHeaders = null;
    }

    @Override
    public void onComplete() {
        final HttpData content = finish();
        String followUrl = null;
        if ((headers.status().equals(HttpStatus.MOVED_PERMANENTLY) ||
                headers.status().equals(HttpStatus.TEMPORARY_REDIRECT) ||
                headers.status().equals(HttpStatus.FOUND) ||
                headers.status().equals(HttpStatus.SEE_OTHER))
                && headers.contains(HttpHeaderNames.LOCATION)) {
            followUrl = headers.get(HttpHeaderNames.LOCATION);
        }
        future().complete(AggregatedHttpMessage.of(
                informationals != null ? informationals : Collections.emptyList(),
                headers, content, trailingHeaders, followUrl));
    }
}
