package org.xbib.helianthus.common.logging;

import static java.util.Objects.requireNonNull;

import io.netty.channel.Channel;
import org.xbib.helianthus.common.Scheme;
import org.xbib.helianthus.common.SerializationFormat;
import org.xbib.helianthus.common.SessionProtocol;

public final class DefaultRequestLog
        extends AbstractMessageLog<RequestLog> implements RequestLog, RequestLogBuilder {

    private Channel channel;
    private SessionProtocol sessionProtocol;
    private SerializationFormat serializationFormat = SerializationFormat.NONE;
    private String host;
    private String method;
    private String path;

    @Override
    public void start(Channel channel, SessionProtocol sessionProtocol, String host, String method, String path) {
        requireNonNull(channel, "channel");
        requireNonNull(sessionProtocol, "sessionProtocol");
        requireNonNull(host, "host");
        requireNonNull(method, "method");
        requireNonNull(path, "path");

        if (!start0()) {
            return;
        }

        this.channel = channel;
        this.sessionProtocol = sessionProtocol;
        this.host = host;
        this.method = method;
        this.path = path;
    }

    @Override
    public Channel channel() {
        return channel;
    }

    @Override
    public void serializationFormat(SerializationFormat serializationFormat) {
        requireNonNull(serializationFormat, "serializationFormat");
        if (isDone()) {
            return;
        }
        this.serializationFormat = serializationFormat;
    }

    @Override
    public Scheme scheme() {
        return Scheme.of(serializationFormat, sessionProtocol);
    }

    @Override
    public String host() {
        return host;
    }

    @Override
    public String method() {
        return method;
    }

    @Override
    public String path() {
        return path;
    }

    @Override
    protected void append(StringBuilder sb) {
        sb.append("channel").append(channel)
                .append("scheme")
                .append(serializationFormat != null ? serializationFormat.uriText() : null)
                .append('+')
                .append(sessionProtocol != null ? sessionProtocol.uriText() : null)
                .append("host").append(host)
                .append("method").append(method)
                .append("path").append(path);
    }
}
