package org.xbib.helianthus.common.logging;

import io.netty.channel.Channel;
import io.netty.util.AttributeKey;
import org.xbib.helianthus.common.RpcRequest;
import org.xbib.helianthus.common.Scheme;
import org.xbib.helianthus.common.http.HttpHeaders;

public interface RequestLog extends MessageLog {
    AttributeKey<HttpHeaders> HTTP_HEADERS = AttributeKey.valueOf(RequestLog.class, "HTTP_HEADERS");
    AttributeKey<RpcRequest> RPC_REQUEST = AttributeKey.valueOf(RequestLog.class, "RPC_REQUEST");

    Channel channel();

    Scheme scheme();

    String host();

    String method();

    String path();
}
