package org.xbib.helianthus.common.logging;

import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import org.xbib.helianthus.internal.NoopAttribute;

public interface ResponseLogBuilder extends MessageLogBuilder {

    ResponseLogBuilder NOOP = new ResponseLogBuilder() {
        @Override
        public void statusCode(int statusCode) {
        }

        @Override
        public void start() {
        }

        @Override
        public void increaseContentLength(long deltaBytes) {
        }

        @Override
        public void contentLength(long contentLength) {
        }

        @Override
        public <T> Attribute<T> attr(AttributeKey<T> key) {
            return new NoopAttribute<>(key);
        }

        @Override
        public <T> boolean hasAttr(AttributeKey<T> key) {
            return false;
        }

        @Override
        public void end() {
        }

        @Override
        public void end(Throwable cause) {
        }
    };

    void start();

    void statusCode(int statusCode);

}
