package org.xbib.helianthus.common.stream;

import org.xbib.helianthus.common.util.Exceptions;

public final class CancelledSubscriptionException extends RuntimeException {

    private static final long serialVersionUID = -7815958463104921571L;

    private static final CancelledSubscriptionException INSTANCE =
            Exceptions.clearTrace(new CancelledSubscriptionException());

    private CancelledSubscriptionException() {
    }

    public static CancelledSubscriptionException get() {
        return Exceptions.isVerbose() ? new CancelledSubscriptionException() : INSTANCE;
    }
}
