package org.xbib.helianthus.common.stream;

import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public interface StreamWriter<T> {

    boolean isOpen();

    boolean write(T o);

    boolean write(Supplier<? extends T> o);

    CompletableFuture<Void> onDemand(Runnable task);

    void close();

    void close(Throwable cause);
}
