package org.xbib.helianthus.internal;

import static java.util.Objects.requireNonNull;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;

import java.text.MessageFormat;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public abstract class IdleTimeoutHandler extends IdleStateHandler {

    private static final Logger logger = Logger.getLogger(IdleTimeoutHandler.class.getName());

    private final String name;

    protected IdleTimeoutHandler(String name, long idleTimeoutMillis) {
        super(0, 0, idleTimeoutMillis, TimeUnit.MILLISECONDS);
        this.name = requireNonNull(name, "name");
    }

    @Override
    protected final void channelIdle(ChannelHandlerContext ctx, IdleStateEvent evt) throws Exception {
        if (!evt.isFirst()) {
            return;
        }

        if (!hasRequestsInProgress(ctx)) {
            logger.fine(MessageFormat.format("{0} Closing an idle {1} connection", ctx.channel(), name));
            ctx.close();
        }
    }

    protected abstract boolean hasRequestsInProgress(ChannelHandlerContext ctx);
}
