/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.common;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.EventLoop;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.xbib.helianthus.common.RequestContext;
import org.xbib.helianthus.common.SessionProtocol;
import org.xbib.helianthus.internal.DefaultAttributeMap;

public abstract class AbstractRequestContext
extends DefaultAttributeMap
implements RequestContext {
    private final SessionProtocol sessionProtocol;
    private final String method;
    private final String path;
    private final Object request;
    private List<Runnable> onEnterCallbacks;
    private List<Runnable> onExitCallbacks;

    protected AbstractRequestContext(SessionProtocol sessionProtocol, String method, String path, Object request) {
        this.sessionProtocol = sessionProtocol;
        this.method = method;
        this.path = path;
        this.request = request;
    }

    @Override
    public final SessionProtocol sessionProtocol() {
        return this.sessionProtocol;
    }

    @Override
    public final String method() {
        return this.method;
    }

    @Override
    public final String path() {
        return this.path;
    }

    @Override
    public final <T> T request() {
        return (T)this.request;
    }

    @Override
    public final EventLoop contextAwareEventLoop() {
        return RequestContext.super.contextAwareEventLoop();
    }

    @Override
    public final Executor makeContextAware(Executor executor) {
        return RequestContext.super.makeContextAware(executor);
    }

    @Override
    public final <T> Callable<T> makeContextAware(Callable<T> callable) {
        return () -> {
            try (RequestContext.PushHandle ignored = this.propagateContextIfNotPresent();){
                Object v = callable.call();
                return v;
            }
        };
    }

    @Override
    public final Runnable makeContextAware(Runnable runnable) {
        return () -> {
            try (RequestContext.PushHandle ignored = this.propagateContextIfNotPresent();){
                runnable.run();
            }
        };
    }

    @Override
    public final <T> FutureListener<T> makeContextAware(FutureListener<T> listener) {
        return future -> this.invokeOperationComplete((GenericFutureListener)listener, (Future)future);
    }

    @Override
    public final ChannelFutureListener makeContextAware(ChannelFutureListener listener) {
        return future -> this.invokeOperationComplete((GenericFutureListener)listener, (Future)future);
    }

    @Override
    public final <T extends Future<?>> GenericFutureListener<T> makeContextAware(GenericFutureListener<T> listener) {
        return future -> this.invokeOperationComplete(listener, future);
    }

    private <T extends Future<?>> void invokeOperationComplete(GenericFutureListener<T> listener, T future) throws Exception {
        try (RequestContext.PushHandle ignored = this.propagateContextIfNotPresent();){
            listener.operationComplete(future);
        }
    }

    private RequestContext.PushHandle propagateContextIfNotPresent() {
        return RequestContext.mapCurrent(currentContext -> {
            if (currentContext != this) {
                throw new IllegalStateException("Trying to call object made with makeContextAware or object on executor made with makeContextAware with context " + this + ", but context is currently set to " + currentContext + ". This means the callback was passed from one invocation to another which is not allowed. Make sure you are not saving callbacks into shared state.");
            }
            return () -> {};
        }, () -> {
            RequestContext.PushHandle handle = RequestContext.push(this);
            List<Runnable> onEnterCallbacks = this.onEnterCallbacks;
            if (onEnterCallbacks != null) {
                onEnterCallbacks.forEach(Runnable::run);
            }
            return () -> {
                handle.close();
                List<Runnable> onExitCallbacks = this.onExitCallbacks;
                if (onExitCallbacks != null) {
                    onExitCallbacks.forEach(Runnable::run);
                }
            };
        });
    }

    @Override
    public final void onEnter(Runnable callback) {
        if (this.onEnterCallbacks == null) {
            this.onEnterCallbacks = new ArrayList<Runnable>(4);
        }
        this.onEnterCallbacks.add(callback);
    }

    @Override
    public final void onExit(Runnable callback) {
        if (this.onExitCallbacks == null) {
            this.onExitCallbacks = new ArrayList<Runnable>(4);
        }
        this.onExitCallbacks.add(callback);
    }

    @Override
    @Deprecated
    public final void resolvePromise(Promise<?> promise, Object result) {
        RequestContext.super.resolvePromise(promise, result);
    }

    @Override
    @Deprecated
    public final void rejectPromise(Promise<?> promise, Throwable cause) {
        RequestContext.super.rejectPromise(promise, cause);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }
}

