/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.common;

import java.util.List;
import java.util.Objects;
import org.xbib.helianthus.common.RpcRequest;

public class AbstractRpcRequest
implements RpcRequest {
    private final Class<?> serviceType;
    private final String method;
    private final List<Object> args;

    protected AbstractRpcRequest(Class<?> serviceType, String method, List<Object> args) {
        this.serviceType = Objects.requireNonNull(serviceType, "serviceType");
        this.method = Objects.requireNonNull(method, "method");
        this.args = args;
    }

    @Override
    public final Class<?> serviceType() {
        return this.serviceType;
    }

    @Override
    public final String method() {
        return this.method;
    }

    @Override
    public final List<Object> params() {
        return this.args;
    }

    public int hashCode() {
        return this.method().hashCode() * 31 + this.params().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AbstractRpcRequest)) {
            return false;
        }
        AbstractRpcRequest that = (AbstractRpcRequest)obj;
        return this.method().equals(that.method()) && this.params().equals(that.params());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AbstractRpcRequest:serviceType=").append(this.simpleServiceName()).append(",method=").append(this.method()).append(",args=").append(this.params());
        return sb.toString();
    }

    protected final String simpleServiceName() {
        Class<?> serviceType = this.serviceType();
        String fqcn = serviceType.getName();
        int lastDot = fqcn.lastIndexOf(46);
        return lastDot < 0 ? fqcn : fqcn.substring(lastDot + 1);
    }
}

