/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.common;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Stream;
import org.xbib.helianthus.common.RequestContext;

final class RequestContextAwarePromise<T>
implements Promise<T> {
    private final RequestContext context;
    private final Promise<T> delegate;

    RequestContextAwarePromise(RequestContext context, Promise<T> delegate) {
        this.context = context;
        this.delegate = delegate;
    }

    public Promise<T> setSuccess(T result) {
        return this.delegate.setSuccess(result);
    }

    public boolean trySuccess(T result) {
        return this.delegate.trySuccess(result);
    }

    public Promise<T> setFailure(Throwable cause) {
        return this.delegate.setFailure(cause);
    }

    public boolean tryFailure(Throwable cause) {
        return this.delegate.tryFailure(cause);
    }

    public boolean setUncancellable() {
        return this.delegate.setUncancellable();
    }

    public Promise<T> addListener(GenericFutureListener<? extends Future<? super T>> listener) {
        return this.delegate.addListener(this.context.makeContextAware(listener));
    }

    public Promise<T> addListeners(GenericFutureListener<? extends Future<? super T>> ... listeners) {
        return this.delegate.addListeners((GenericFutureListener[])Stream.of(listeners).map(this.context::makeContextAware).toArray(GenericFutureListener[]::new));
    }

    public Promise<T> removeListener(GenericFutureListener<? extends Future<? super T>> listener) {
        return this.delegate.removeListener(listener);
    }

    @SafeVarargs
    public final Promise<T> removeListeners(GenericFutureListener<? extends Future<? super T>> ... listeners) {
        return this.delegate.removeListeners(listeners);
    }

    public Promise<T> await() throws InterruptedException {
        return this.delegate.await();
    }

    public Promise<T> awaitUninterruptibly() {
        return this.delegate.awaitUninterruptibly();
    }

    public Promise<T> sync() throws InterruptedException {
        return this.delegate.sync();
    }

    public Promise<T> syncUninterruptibly() {
        return this.delegate.syncUninterruptibly();
    }

    public boolean isSuccess() {
        return this.delegate.isSuccess();
    }

    public boolean isCancellable() {
        return this.delegate.isCancellable();
    }

    public Throwable cause() {
        return this.delegate.cause();
    }

    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.await(timeout, unit);
    }

    public boolean await(long timeoutMillis) throws InterruptedException {
        return this.delegate.await(timeoutMillis);
    }

    public boolean awaitUninterruptibly(long timeout, TimeUnit unit) {
        return this.delegate.awaitUninterruptibly(timeout, unit);
    }

    public boolean awaitUninterruptibly(long timeoutMillis) {
        return this.delegate.awaitUninterruptibly(timeoutMillis);
    }

    public T getNow() {
        return (T)this.delegate.getNow();
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.delegate.cancel(mayInterruptIfRunning);
    }

    public boolean isCancelled() {
        return this.delegate.isCancelled();
    }

    public boolean isDone() {
        return this.delegate.isDone();
    }

    public T get() throws InterruptedException, ExecutionException {
        return (T)this.delegate.get();
    }

    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (T)this.delegate.get(timeout, unit);
    }
}

