/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.common;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

public enum SessionProtocol {
    HTTP(false, "http", "HTTP/1.1", false, 80),
    HTTPS(true, "https", "HTTP/1.1", false, 443),
    H1(true, "h1", "HTTP/1.1", false, 443),
    H1C(false, "h1c", "HTTP/1.1", false, 80),
    H2(true, "h2", "HTTP/2", true, 443),
    H2C(false, "h2c", "HTTP/2", true, 80);

    private static final Set<SessionProtocol> HTTP_PROTOCOLS;
    private final boolean useTls;
    private final String uriText;
    private final String protocolVersionText;
    private final boolean isMultiplex;
    private final int defaultPort;

    private SessionProtocol(boolean useTls, String uriText, String protocolVersionText, boolean isMultiplex, int defaultPort) {
        this.useTls = useTls;
        this.uriText = uriText;
        this.protocolVersionText = protocolVersionText;
        this.isMultiplex = isMultiplex;
        this.defaultPort = defaultPort;
    }

    public static Set<SessionProtocol> ofHttp() {
        return HTTP_PROTOCOLS;
    }

    public boolean isTls() {
        return this.useTls;
    }

    public String uriText() {
        return this.uriText;
    }

    public String protocolVersionText() {
        return this.protocolVersionText;
    }

    public boolean isMultiplex() {
        return this.isMultiplex;
    }

    public int defaultPort() {
        return this.defaultPort;
    }

    static {
        HTTP_PROTOCOLS = Collections.unmodifiableSet(EnumSet.of(HTTP, new SessionProtocol[]{HTTPS, H1, H1C, H2, H2C}));
    }
}

