/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.common.http;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.xbib.helianthus.common.http.DefaultAggregatedHttpMessage;
import org.xbib.helianthus.common.http.HttpData;
import org.xbib.helianthus.common.http.HttpHeaders;
import org.xbib.helianthus.common.http.HttpMethod;
import org.xbib.helianthus.common.http.HttpStatus;
import org.xbib.helianthus.common.util.CollectionUtil;

public interface AggregatedHttpMessage {
    public static AggregatedHttpMessage of(HttpMethod method, String path) {
        return AggregatedHttpMessage.of(HttpHeaders.of(method, path));
    }

    public static AggregatedHttpMessage of(HttpMethod method, String path, HttpData content) {
        return AggregatedHttpMessage.of(HttpHeaders.of(method, path), content);
    }

    public static AggregatedHttpMessage of(int statusCode) {
        return AggregatedHttpMessage.of(HttpStatus.valueOf(statusCode));
    }

    public static AggregatedHttpMessage of(HttpStatus status) {
        return AggregatedHttpMessage.of(HttpHeaders.of(status));
    }

    public static AggregatedHttpMessage of(HttpStatus status, HttpData content) {
        return AggregatedHttpMessage.of(HttpHeaders.of(status), content);
    }

    public static AggregatedHttpMessage of(HttpHeaders headers, HttpStatus status, HttpData content) {
        return AggregatedHttpMessage.of(headers.status(status), content);
    }

    public static AggregatedHttpMessage of(HttpHeaders headers) {
        return AggregatedHttpMessage.of(headers, HttpData.EMPTY_DATA, HttpHeaders.EMPTY_HEADERS, null);
    }

    public static AggregatedHttpMessage of(HttpHeaders headers, HttpData content) {
        return AggregatedHttpMessage.of(headers, content, HttpHeaders.EMPTY_HEADERS, null);
    }

    public static AggregatedHttpMessage of(HttpHeaders headers, HttpData content, HttpHeaders trailingHeaders, String followUrl) {
        return AggregatedHttpMessage.of(Collections.emptyList(), headers, content, trailingHeaders, followUrl);
    }

    public static AggregatedHttpMessage of(Iterable<HttpHeaders> informationals, HttpHeaders headers, HttpData content, HttpHeaders trailingHeaders, String followUrl) {
        Objects.requireNonNull(informationals, "informationals");
        Objects.requireNonNull(headers, "headers");
        Objects.requireNonNull(content, "content");
        Objects.requireNonNull(trailingHeaders, "trailingHeaders");
        return new DefaultAggregatedHttpMessage(CollectionUtil.makeList(informationals), headers, content, trailingHeaders, followUrl);
    }

    public List<HttpHeaders> informationals();

    public HttpHeaders headers();

    public HttpHeaders trailingHeaders();

    public HttpData content();

    public String followUrl();

    default public String scheme() {
        return this.headers().scheme();
    }

    default public HttpMethod method() {
        return this.headers().method();
    }

    default public String path() {
        return this.headers().path();
    }

    default public String authority() {
        return this.headers().authority();
    }

    default public HttpStatus status() {
        return this.headers().status();
    }
}

