/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.common.http;

import java.util.Arrays;
import org.xbib.helianthus.common.http.HttpData;

final class DefaultHttpData
implements HttpData {
    static final HttpData EMPTY_DATA = new DefaultHttpData(new byte[0], 0, 0);
    private final byte[] data;
    private final int offset;
    private final int length;

    DefaultHttpData(byte[] data, int offset, int length) {
        this.data = data;
        this.offset = offset;
        this.length = length;
    }

    @Override
    public byte[] array() {
        return this.data;
    }

    @Override
    public int offset() {
        return this.offset;
    }

    @Override
    public int length() {
        return this.length;
    }

    public int hashCode() {
        int end = this.offset + this.length;
        int hash = 1;
        for (int i = this.offset; i < end; ++i) {
            hash = hash * 31 + this.data[i];
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HttpData)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        HttpData that = (HttpData)obj;
        if (this.length() != that.length()) {
            return false;
        }
        int endOffset = this.offset + this.length;
        int i = this.offset;
        int j = that.offset();
        while (i < endOffset) {
            if (this.data[i] != this.data[j]) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("offset=").append(this.offset).append(",length=").append(this.length).append(",array=").append(Arrays.toString(this.data));
        return sb.toString();
    }
}

