/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.common.http;

import io.netty.handler.codec.Headers;
import io.netty.util.AsciiString;
import java.util.Iterator;
import java.util.Map;
import org.xbib.helianthus.common.http.DefaultHttpHeaders;
import org.xbib.helianthus.common.http.HttpMethod;
import org.xbib.helianthus.common.http.HttpObject;
import org.xbib.helianthus.common.http.HttpStatus;
import org.xbib.helianthus.common.http.ImmutableHttpHeaders;

public interface HttpHeaders
extends HttpObject,
Headers<AsciiString, String, HttpHeaders> {
    public static final HttpHeaders EMPTY_HEADERS = new DefaultHttpHeaders(false, 0).asImmutable();

    public static HttpHeaders of(HttpMethod method, String path) {
        return new DefaultHttpHeaders().method(method).path(path);
    }

    public static HttpHeaders of(int statusCode) {
        return HttpHeaders.of(HttpStatus.valueOf(statusCode));
    }

    public static HttpHeaders of(HttpStatus status) {
        return new DefaultHttpHeaders().status(status);
    }

    public static HttpHeaders of(HttpStatus status, HttpMethod method) {
        return new DefaultHttpHeaders().status(status).method(method);
    }

    public static HttpHeaders of(HttpStatus status, HttpMethod method, String path) {
        return new DefaultHttpHeaders().status(status).method(method).path(path);
    }

    public static HttpHeaders of(HttpHeaders headers, HttpStatus status, HttpMethod method, String path) {
        return headers.status(status).method(method).path(path);
    }

    public static HttpHeaders of(AsciiString name, String value) {
        return (HttpHeaders)new DefaultHttpHeaders().add(name, value);
    }

    public static HttpHeaders of(AsciiString name1, String value1, AsciiString name2, String value2) {
        return (HttpHeaders)((HttpHeaders)new DefaultHttpHeaders().add(name1, value1)).add(name2, value2);
    }

    public static HttpHeaders of(AsciiString name1, String value1, AsciiString name2, String value2, AsciiString name3, String value3) {
        return (HttpHeaders)((HttpHeaders)((HttpHeaders)new DefaultHttpHeaders().add(name1, value1)).add(name2, value2)).add(name3, value3);
    }

    public static HttpHeaders of(AsciiString name1, String value1, AsciiString name2, String value2, AsciiString name3, String value3, AsciiString name4, String value4) {
        return (HttpHeaders)((HttpHeaders)((HttpHeaders)((HttpHeaders)new DefaultHttpHeaders().add(name1, value1)).add(name2, value2)).add(name3, value3)).add(name4, value4);
    }

    public Iterator<Map.Entry<AsciiString, String>> iterator();

    public HttpHeaders method(HttpMethod var1);

    public HttpHeaders scheme(String var1);

    public HttpHeaders authority(String var1);

    public HttpHeaders path(String var1);

    public HttpHeaders status(int var1);

    public HttpHeaders status(HttpStatus var1);

    public HttpMethod method();

    public String scheme();

    public String authority();

    public String path();

    public HttpStatus status();

    default public HttpHeaders asImmutable() {
        return new ImmutableHttpHeaders(this);
    }
}

