/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.common.http;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.reactivestreams.Publisher;
import org.xbib.helianthus.common.Response;
import org.xbib.helianthus.common.http.AggregatedHttpMessage;
import org.xbib.helianthus.common.http.HttpObject;
import org.xbib.helianthus.common.http.HttpResponseAggregator;
import org.xbib.helianthus.common.http.PublisherBasedHttpResponse;
import org.xbib.helianthus.common.stream.StreamMessage;

public interface HttpResponse
extends Response,
StreamMessage<HttpObject> {
    public static HttpResponse of(Publisher<? extends HttpObject> publisher) {
        return new PublisherBasedHttpResponse(publisher);
    }

    default public CompletableFuture<AggregatedHttpMessage> aggregate() {
        CompletableFuture<AggregatedHttpMessage> future = new CompletableFuture<AggregatedHttpMessage>();
        this.subscribe(new HttpResponseAggregator(future));
        return future;
    }

    @Override
    public CompletableFuture<Void> closeFuture();

    default public CompletableFuture<AggregatedHttpMessage> aggregate(Executor executor) {
        CompletableFuture<AggregatedHttpMessage> future = new CompletableFuture<AggregatedHttpMessage>();
        this.subscribe(new HttpResponseAggregator(future), executor);
        return future;
    }
}

