/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.common.http;

import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Objects;
import org.xbib.helianthus.common.http.AggregatedHttpMessage;
import org.xbib.helianthus.common.http.HttpData;
import org.xbib.helianthus.common.http.HttpHeaderNames;
import org.xbib.helianthus.common.http.HttpHeaders;
import org.xbib.helianthus.common.http.HttpObject;
import org.xbib.helianthus.common.http.HttpStatus;
import org.xbib.helianthus.common.http.HttpStatusClass;
import org.xbib.helianthus.common.stream.StreamWriter;
import org.xbib.helianthus.internal.http.HelianthusHttpUtil;

public interface HttpResponseWriter
extends StreamWriter<HttpObject> {
    default public void respond(int statusCode) {
        this.respond(HttpStatus.valueOf(statusCode));
    }

    default public void respond(HttpStatus status) {
        Objects.requireNonNull(status, "status");
        if (status.codeClass() == HttpStatusClass.INFORMATIONAL) {
            this.write(HttpHeaders.of(status));
        } else if (HelianthusHttpUtil.isContentAlwaysEmpty(status)) {
            this.write(HttpHeaders.of(status));
            this.close();
        } else {
            this.respond(status, "text/plain", status.toHttpData());
        }
    }

    default public void respond(HttpStatus status, String mediaType, String content) {
        Objects.requireNonNull(status, "status");
        Objects.requireNonNull(content, "content");
        Objects.requireNonNull(mediaType, "mediaType");
        this.respond(status, mediaType, content.getBytes(StandardCharsets.UTF_8));
    }

    default public void respond(HttpStatus status, String mediaType, String format, Object ... args) {
        Objects.requireNonNull(status, "status");
        Objects.requireNonNull(mediaType, "mediaType");
        Objects.requireNonNull(format, "format");
        Objects.requireNonNull(args, "args");
        this.respond(status, mediaType, String.format(Locale.ENGLISH, format, args).getBytes(StandardCharsets.UTF_8));
    }

    default public void respond(HttpStatus status, String mediaType, byte[] content) {
        Objects.requireNonNull(content, "content");
        this.respond(status, mediaType, HttpData.of(content));
    }

    default public void respond(HttpStatus status, String mediaType, byte[] content, int offset, int length) {
        Objects.requireNonNull(content, "content");
        this.respond(status, mediaType, HttpData.of(content, offset, length));
    }

    default public void respond(HttpStatus status, String mediaType, HttpData content) {
        Objects.requireNonNull(status, "status");
        Objects.requireNonNull(content, "content");
        Objects.requireNonNull(mediaType, "mediaType");
        int length = content.length();
        HttpHeaders headers = (HttpHeaders)((HttpHeaders)HttpHeaders.of(status).set(HttpHeaderNames.CONTENT_TYPE, mediaType)).setInt(HttpHeaderNames.CONTENT_LENGTH, length);
        if (HelianthusHttpUtil.isContentAlwaysEmpty(status)) {
            if (length != 0) {
                throw new IllegalArgumentException("A " + status + " response must have empty content: " + length + " byte(s)");
            }
            this.write(headers);
        } else {
            this.write(headers);
            this.write(content);
        }
        this.close();
    }

    default public void respond(AggregatedHttpMessage res) {
        HttpHeaders trailingHeaders;
        HttpHeaders headers = res.headers();
        this.write(headers);
        HttpData content = res.content();
        if (HelianthusHttpUtil.isContentAlwaysEmpty(headers.status())) {
            if (!content.isEmpty()) {
                throw new IllegalArgumentException("A " + headers.status() + " response must have empty content: " + content.length() + " byte(s)");
            }
            if (!res.trailingHeaders().isEmpty()) {
                throw new IllegalArgumentException("A " + headers.status() + " response must not have trailing headers: " + res.trailingHeaders());
            }
            this.close();
            return;
        }
        if (!content.isEmpty()) {
            this.write(content);
        }
        if (!(trailingHeaders = res.trailingHeaders()).isEmpty()) {
            this.write(trailingHeaders);
        }
        this.close();
    }
}

