/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.common.logging;

import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.xbib.helianthus.common.logging.MessageLog;
import org.xbib.helianthus.common.logging.MessageLogBuilder;
import org.xbib.helianthus.common.util.CompletionActions;
import org.xbib.helianthus.common.util.ExceptionFormatter;
import org.xbib.helianthus.common.util.UnitFormatter;
import org.xbib.helianthus.internal.DefaultAttributeMap;

abstract class AbstractMessageLog<T extends MessageLog>
extends CompletableFuture<T>
implements MessageLog,
MessageLogBuilder {
    private final DefaultAttributeMap attrs = new DefaultAttributeMap();
    private boolean startTimeNanosSet;
    private long startTimeNanos;
    private long contentLength;
    private long endTimeNanos;
    private Throwable cause;

    AbstractMessageLog() {
    }

    boolean start0() {
        if (this.isDone() || this.startTimeNanosSet) {
            return false;
        }
        this.startTimeNanos = System.nanoTime();
        this.startTimeNanosSet = true;
        return true;
    }

    @Override
    public long startTimeNanos() {
        return this.startTimeNanos;
    }

    @Override
    public void increaseContentLength(long deltaBytes) {
        if (deltaBytes < 0L) {
            throw new IllegalArgumentException("deltaBytes: " + deltaBytes + " (expected: >= 0)");
        }
        if (this.isDone()) {
            return;
        }
        this.contentLength += deltaBytes;
    }

    @Override
    public void contentLength(long contentLength) {
        if (contentLength < 0L) {
            throw new IllegalArgumentException("contentLength: " + contentLength + " (expected: >= 0)");
        }
        if (this.isDone()) {
            return;
        }
        this.contentLength = contentLength;
    }

    @Override
    public long contentLength() {
        return this.contentLength;
    }

    public <V> Attribute<V> attr(AttributeKey<V> key) {
        return this.attrs.attr(key);
    }

    public <V> boolean hasAttr(AttributeKey<V> key) {
        return this.attrs.hasAttr(key);
    }

    @Override
    public Iterator<Attribute<?>> attrs() {
        return this.attrs.attrs();
    }

    @Override
    public void end() {
        this.end0(null);
    }

    @Override
    public void end(Throwable cause) {
        Objects.requireNonNull(cause, "cause");
        this.end0(cause);
    }

    private void end0(Throwable cause) {
        if (this.isDone()) {
            return;
        }
        this.cause = cause;
        this.start0();
        Iterator<Attribute<?>> attrs = this.attrs();
        if (attrs.hasNext()) {
            CompletableFuture<Void> future;
            ArrayList<CompletableFuture> dependencies = new ArrayList<CompletableFuture>(4);
            do {
                CompletableFuture f;
                Object a;
                if (!((a = attrs.next().get()) instanceof CompletableFuture) || (f = (CompletableFuture)a).isDone()) continue;
                dependencies.add(f);
            } while (attrs.hasNext());
            switch (dependencies.size()) {
                case 0: {
                    this.complete();
                    return;
                }
                case 1: {
                    future = (CompletableFuture<Void>)dependencies.get(0);
                    break;
                }
                default: {
                    future = CompletableFuture.allOf(dependencies.toArray(new CompletableFuture[dependencies.size()]));
                }
            }
            ((CompletableFuture)future.handle((T unused1, U unused2) -> this.complete())).exceptionally(CompletionActions::log);
        } else {
            this.complete();
        }
    }

    private Void complete() {
        this.endTimeNanos = System.nanoTime();
        this.complete(this.self());
        return null;
    }

    @Override
    public long endTimeNanos() {
        return this.endTimeNanos;
    }

    @Override
    public Throwable cause() {
        return this.cause;
    }

    private T self() {
        return (T)this;
    }

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("timeSpan=").append(this.startTimeNanos).append("+").append((CharSequence)UnitFormatter.elapsed(this.startTimeNanos, this.endTimeNanos)).append(",contentLength=").append((CharSequence)UnitFormatter.size(this.contentLength));
        this.append(sb);
        sb.append(",cause=").append(ExceptionFormatter.format(this.cause)).append(",attrs=").append(this.attrs);
        return sb.toString();
    }

    protected abstract void append(StringBuilder var1);
}

