/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.common.logging;

import io.netty.channel.Channel;
import java.util.Objects;
import org.xbib.helianthus.common.Scheme;
import org.xbib.helianthus.common.SerializationFormat;
import org.xbib.helianthus.common.SessionProtocol;
import org.xbib.helianthus.common.logging.AbstractMessageLog;
import org.xbib.helianthus.common.logging.RequestLog;
import org.xbib.helianthus.common.logging.RequestLogBuilder;

public final class DefaultRequestLog
extends AbstractMessageLog<RequestLog>
implements RequestLog,
RequestLogBuilder {
    private Channel channel;
    private SessionProtocol sessionProtocol;
    private SerializationFormat serializationFormat = SerializationFormat.NONE;
    private String host;
    private String method;
    private String path;

    @Override
    public void start(Channel channel, SessionProtocol sessionProtocol, String host, String method, String path) {
        Objects.requireNonNull(channel, "channel");
        Objects.requireNonNull(sessionProtocol, "sessionProtocol");
        Objects.requireNonNull(host, "host");
        Objects.requireNonNull(method, "method");
        Objects.requireNonNull(path, "path");
        if (!this.start0()) {
            return;
        }
        this.channel = channel;
        this.sessionProtocol = sessionProtocol;
        this.host = host;
        this.method = method;
        this.path = path;
    }

    @Override
    public Channel channel() {
        return this.channel;
    }

    @Override
    public void serializationFormat(SerializationFormat serializationFormat) {
        Objects.requireNonNull(serializationFormat, "serializationFormat");
        if (this.isDone()) {
            return;
        }
        this.serializationFormat = serializationFormat;
    }

    @Override
    public Scheme scheme() {
        return Scheme.of(this.serializationFormat, this.sessionProtocol);
    }

    @Override
    public String host() {
        return this.host;
    }

    @Override
    public String method() {
        return this.method;
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    protected void append(StringBuilder sb) {
        sb.append("channel").append(this.channel).append("scheme").append(this.serializationFormat != null ? this.serializationFormat.uriText() : null).append('+').append(this.sessionProtocol != null ? this.sessionProtocol.uriText() : null).append("host").append(this.host).append("method").append(this.method).append("path").append(this.path);
    }
}

