/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.common.logging;

import java.util.Objects;
import org.xbib.helianthus.common.RequestContext;
import org.xbib.helianthus.common.logging.MessageLogConsumerInvoker;
import org.xbib.helianthus.common.logging.RequestLog;
import org.xbib.helianthus.common.logging.ResponseLog;

public interface MessageLogConsumer {
    public void onRequest(RequestContext var1, RequestLog var2) throws Exception;

    public void onResponse(RequestContext var1, ResponseLog var2) throws Exception;

    default public MessageLogConsumer andThen(MessageLogConsumer other) {
        Objects.requireNonNull(other, "other");
        final MessageLogConsumer first = this;
        final MessageLogConsumer second = other;
        return new MessageLogConsumer(){

            @Override
            public void onRequest(RequestContext ctx, RequestLog req) throws Exception {
                MessageLogConsumerInvoker.invokeOnRequest(first, ctx, req);
                second.onRequest(ctx, req);
            }

            @Override
            public void onResponse(RequestContext ctx, ResponseLog res) throws Exception {
                MessageLogConsumerInvoker.invokeOnResponse(first, ctx, res);
                second.onResponse(ctx, res);
            }
        };
    }
}

