/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.common.stream;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.xbib.helianthus.common.stream.CancelledSubscriptionException;
import org.xbib.helianthus.common.stream.StreamMessage;

public class PublisherBasedStreamMessage<T>
implements StreamMessage<T> {
    private static final AbortableSubscriber ABORTED_SUBSCRIBER = new AbortedSubscriber();
    private static final AtomicReferenceFieldUpdater<PublisherBasedStreamMessage, AbortableSubscriber> subscriberUpdater = AtomicReferenceFieldUpdater.newUpdater(PublisherBasedStreamMessage.class, AbortableSubscriber.class, "subscriber");
    private final Publisher<? extends T> publisher;
    private final CompletableFuture<Void> closeFuture = new CompletableFuture();
    private volatile AbortableSubscriber subscriber;
    private volatile boolean publishedAny;

    public PublisherBasedStreamMessage(Publisher<? extends T> publisher) {
        this.publisher = publisher;
    }

    protected Publisher<? extends T> delegate() {
        return this.publisher;
    }

    @Override
    public boolean isOpen() {
        return !this.closeFuture.isDone();
    }

    @Override
    public boolean isEmpty() {
        return !this.isOpen() && !this.publishedAny;
    }

    @Override
    public void subscribe(Subscriber<? super T> subscriber) {
        Objects.requireNonNull(subscriber, "subscriber");
        this.subscribe0(subscriber, null);
    }

    @Override
    public void subscribe(Subscriber<? super T> subscriber, Executor executor) {
        Objects.requireNonNull(subscriber, "subscriber");
        Objects.requireNonNull(executor, "executor");
        this.subscribe0(subscriber, executor);
    }

    private void subscribe0(Subscriber<? super T> subscriber, Executor executor) {
        SubscriberWrapper s = new SubscriberWrapper(this, subscriber, executor);
        if (!subscriberUpdater.compareAndSet(this, null, s)) {
            if (this.subscriber == ABORTED_SUBSCRIBER) {
                throw new IllegalStateException("cannot subscribe to an aborted publisher");
            }
            throw new IllegalStateException("subscribed by other subscriber already: " + subscriber);
        }
        this.publisher.subscribe((Subscriber)s);
    }

    @Override
    public void abort() {
        AbortableSubscriber s = subscriberUpdater.getAndSet(this, ABORTED_SUBSCRIBER);
        if (s != null) {
            s.abort();
        }
    }

    @Override
    public CompletableFuture<Void> closeFuture() {
        return this.closeFuture;
    }

    static final class SubscriptionWrapper
    implements Subscription {
        private final PublisherBasedStreamMessage<?> parent;
        private final Executor executor;
        private final Subscription s;

        SubscriptionWrapper(PublisherBasedStreamMessage<?> parent, Executor executor, Subscription s) {
            this.parent = parent;
            this.executor = executor;
            this.s = s;
        }

        public void request(long n) {
            this.s.request(n);
        }

        public void cancel() {
            try {
                this.s.cancel();
            }
            finally {
                if (this.executor == null) {
                    this.completeCloseFuture();
                } else {
                    this.executor.execute(this::completeCloseFuture);
                }
            }
        }

        private void completeCloseFuture() {
            this.parent.closeFuture().completeExceptionally(CancelledSubscriptionException.get());
        }
    }

    static final class SubscriberWrapper
    implements AbortableSubscriber {
        private final PublisherBasedStreamMessage<?> parent;
        private final Subscriber<Object> subscriber;
        private final Executor executor;
        private boolean abortPending;
        private SubscriptionWrapper subscription;

        SubscriberWrapper(PublisherBasedStreamMessage<?> parent, Subscriber<?> subscriber, Executor executor) {
            this.parent = parent;
            this.subscriber = subscriber;
            this.executor = executor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSubscribe(Subscription s) {
            boolean abortPending;
            SubscriptionWrapper wrappedSubscription;
            SubscriberWrapper subscriberWrapper = this;
            synchronized (subscriberWrapper) {
                this.subscription = wrappedSubscription = new SubscriptionWrapper(this.parent, this.executor, s);
                abortPending = this.abortPending;
            }
            if (this.executor == null) {
                this.onSubscribe0(wrappedSubscription, abortPending);
            } else {
                this.executor.execute(() -> this.onSubscribe0(wrappedSubscription, abortPending));
            }
        }

        private void onSubscribe0(SubscriptionWrapper s, boolean abortPending) {
            try {
                this.subscriber.onSubscribe((Subscription)s);
            }
            finally {
                if (abortPending) {
                    s.cancel();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void abort() {
            SubscriptionWrapper subscription;
            SubscriberWrapper subscriberWrapper = this;
            synchronized (subscriberWrapper) {
                subscription = this.subscription;
                if (subscription == null) {
                    this.abortPending = true;
                    return;
                }
            }
            Executor executor = this.executor;
            if (executor == null) {
                subscription.cancel();
            } else {
                executor.execute(() -> ((Subscription)subscription).cancel());
            }
        }

        public void onNext(Object obj) {
            ((PublisherBasedStreamMessage)this.parent).publishedAny = true;
            Executor executor = this.executor;
            if (executor == null) {
                this.subscriber.onNext(obj);
            } else {
                executor.execute(() -> this.subscriber.onNext(obj));
            }
        }

        public void onError(Throwable cause) {
            Executor executor = this.executor;
            if (executor == null) {
                this.onError0(cause);
            } else {
                executor.execute(() -> this.onError0(cause));
            }
        }

        private void onError0(Throwable cause) {
            try {
                this.subscriber.onError(cause);
            }
            finally {
                this.parent.closeFuture().completeExceptionally(cause);
            }
        }

        public void onComplete() {
            Executor executor = this.executor;
            if (executor == null) {
                this.onComplete0();
            } else {
                executor.execute(this::onComplete0);
            }
        }

        private void onComplete0() {
            try {
                this.subscriber.onComplete();
            }
            finally {
                this.parent.closeFuture().complete(null);
            }
        }
    }

    private static final class AbortedSubscriber
    implements AbortableSubscriber {
        private AbortedSubscriber() {
        }

        @Override
        public void abort() {
        }

        public void onSubscribe(Subscription s) {
        }

        public void onNext(Object o) {
        }

        public void onError(Throwable t) {
        }

        public void onComplete() {
        }
    }

    private static interface AbortableSubscriber
    extends Subscriber<Object> {
        public void abort();
    }
}

