/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.common.util;

import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.handler.codec.http2.Http2Exception;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.xbib.helianthus.common.ClosedSessionException;
import org.xbib.helianthus.common.SessionProtocol;

public final class Exceptions {
    private static final Logger logger = Logger.getLogger(Exceptions.class.getName());
    private static final Pattern IGNORABLE_SOCKET_ERROR_MESSAGE = Pattern.compile("(?:connection.*(?:reset|closed|abort|broken)|broken.*pipe)", 2);
    private static final Pattern IGNORABLE_HTTP2_ERROR_MESSAGE = Pattern.compile("(?:stream closed)", 2);
    private static final StackTraceElement[] EMPTY_STACK_TRACE = new StackTraceElement[0];
    private static final boolean VERBOSE = "true".equals(System.getProperty("org.xbib.helianthus.verboseExceptions", "false"));

    private Exceptions() {
    }

    public static boolean isVerbose() {
        return VERBOSE;
    }

    public static void logIfUnexpected(Logger logger, Channel ch, Throwable cause) {
        if (!logger.isLoggable(Level.WARNING) || Exceptions.isExpected(cause)) {
            return;
        }
        logger.log(Level.WARNING, MessageFormat.format("{0} Unexpected exception:", ch), cause);
    }

    public static void logIfUnexpected(Logger logger, Channel ch, String debugData, Throwable cause) {
        if (!logger.isLoggable(Level.WARNING) || Exceptions.isExpected(cause)) {
            return;
        }
        logger.log(Level.WARNING, MessageFormat.format("{0} Unexpected exception: {1}", ch, debugData), cause);
    }

    public static void logIfUnexpected(Logger logger, Channel ch, SessionProtocol protocol, Throwable cause) {
        if (!logger.isLoggable(Level.WARNING) || Exceptions.isExpected(cause)) {
            return;
        }
        logger.log(Level.WARNING, MessageFormat.format("{0}[{1}] Unexpected exception:", ch, Exceptions.protocolName(protocol)), cause);
    }

    public static void logIfUnexpected(Logger logger, Channel ch, SessionProtocol protocol, String debugData, Throwable cause) {
        if (!logger.isLoggable(Level.WARNING) || Exceptions.isExpected(cause)) {
            return;
        }
        logger.log(Level.WARNING, MessageFormat.format("{0}[{1}] Unexpected exception: {2}", ch, Exceptions.protocolName(protocol), debugData), cause);
    }

    private static String protocolName(SessionProtocol protocol) {
        return protocol != null ? protocol.uriText() : "<unknown>";
    }

    public static boolean isExpected(Throwable cause) {
        if (VERBOSE) {
            return true;
        }
        if (cause instanceof ClosedChannelException || cause instanceof ClosedSessionException) {
            return true;
        }
        String msg = cause.getMessage();
        if (msg != null) {
            if ((cause instanceof IOException || cause instanceof ChannelException) && IGNORABLE_SOCKET_ERROR_MESSAGE.matcher(msg).find()) {
                return true;
            }
            if (cause instanceof Http2Exception && IGNORABLE_HTTP2_ERROR_MESSAGE.matcher(msg).find()) {
                return true;
            }
        }
        return false;
    }

    public static <T extends Throwable> T clearTrace(T exception) {
        Objects.requireNonNull(exception, "exception");
        exception.setStackTrace(EMPTY_STACK_TRACE);
        return exception;
    }

    static {
        logger.info(MessageFormat.format("org.xbib.helianthus.verboseExceptions: {0}", VERBOSE));
    }
}

