/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.common.util;

public final class UnitFormatter {
    private UnitFormatter() {
    }

    public static void appendSize(StringBuilder buf, long size) {
        if (size >= 0x6400000L) {
            buf.append(size / 0x100000L).append("MiB");
        } else if (size >= 102400L) {
            buf.append(size / 1024L).append("KiB");
        } else {
            buf.append(size).append('B');
        }
    }

    public static void appendElapsed(StringBuilder buf, long startTimeNanos, long endTimeNanos) {
        long elapsedNanos = endTimeNanos - startTimeNanos;
        if (elapsedNanos >= 100000000000L) {
            buf.append(elapsedNanos / 1000000000L).append('s');
        } else if (elapsedNanos >= 100000000L) {
            buf.append(elapsedNanos / 1000000L).append("ms");
        } else if (elapsedNanos >= 100000L) {
            buf.append(elapsedNanos / 1000L).append("\u00b5s");
        } else {
            buf.append(elapsedNanos).append("ns");
        }
    }

    public static void appendElapsedAndSize(StringBuilder buf, long startTimeNanos, long endTimeNanos, long size) {
        UnitFormatter.appendElapsed(buf, startTimeNanos, endTimeNanos);
        buf.append(", ");
        UnitFormatter.appendSize(buf, size);
    }

    public static StringBuilder elapsed(long startTimeNanos, long endTimeNanos) {
        StringBuilder buf = new StringBuilder(16);
        UnitFormatter.appendElapsed(buf, startTimeNanos, endTimeNanos);
        return buf;
    }

    public static StringBuilder size(long size) {
        StringBuilder buf = new StringBuilder(16);
        UnitFormatter.appendSize(buf, size);
        return buf;
    }

    public static StringBuilder elapsedAndSize(long startTimeNanos, long endTimeNanos, long size) {
        StringBuilder buf = new StringBuilder(16);
        UnitFormatter.appendElapsedAndSize(buf, startTimeNanos, endTimeNanos, size);
        return buf;
    }
}

