/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.internal;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.internal.ObjectUtil;

public class FlushConsolidationHandler
extends ChannelDuplexHandler {
    private final int explicitFlushAfterFlushes;
    private int flushPendingCount;
    private boolean readInprogess;

    public FlushConsolidationHandler() {
        this(256);
    }

    public FlushConsolidationHandler(int explicitFlushAfterFlushes) {
        this.explicitFlushAfterFlushes = ObjectUtil.checkPositive((int)explicitFlushAfterFlushes, (String)"explicitFlushAfterFlushes");
    }

    public void flush(ChannelHandlerContext ctx) throws Exception {
        if (this.readInprogess) {
            if (++this.flushPendingCount == this.explicitFlushAfterFlushes) {
                this.flushPendingCount = 0;
                ctx.flush();
            }
            return;
        }
        ctx.flush();
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        this.flushIfNeeded(ctx, true);
        ctx.fireChannelReadComplete();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        this.readInprogess = true;
        ctx.fireChannelRead(msg);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.flushIfNeeded(ctx, true);
        ctx.fireExceptionCaught(cause);
    }

    public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        this.flushIfNeeded(ctx, true);
        ctx.disconnect(promise);
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        this.flushIfNeeded(ctx, true);
        ctx.close(promise);
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        if (!ctx.channel().isWritable()) {
            this.flushIfNeeded(ctx, false);
        }
        ctx.fireChannelWritabilityChanged();
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.flushIfNeeded(ctx, false);
    }

    private void flushIfNeeded(ChannelHandlerContext ctx, boolean resetReadInProgress) {
        if (resetReadInProgress) {
            this.readInprogess = false;
        }
        if (this.flushPendingCount > 0) {
            this.flushPendingCount = 0;
            ctx.flush();
        }
    }
}

