/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.internal.http;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.Http2StreamVisitor;
import org.xbib.helianthus.common.util.ExceptionFormatter;

public abstract class AbstractHttp2ConnectionHandler
extends Http2ConnectionHandler {
    private static final Http2StreamVisitor closeAllStreams = stream -> {
        if (stream.state() != Http2Stream.State.CLOSED) {
            stream.close();
        }
        return true;
    };
    private boolean closing;
    private boolean handlingConnectionError;

    protected AbstractHttp2ConnectionHandler(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings) {
        super(decoder, encoder, initialSettings);
    }

    private static String goAwayDebugData(Http2Exception http2Ex, Throwable cause) {
        String message;
        String type;
        StringBuilder buf = new StringBuilder(256);
        if (http2Ex != null) {
            type = http2Ex.getClass().getName();
            message = http2Ex.getMessage();
        } else {
            type = null;
            message = null;
        }
        buf.append("type: ");
        buf.append(type != null ? type : "n/a");
        buf.append(", message: ");
        buf.append(message != null ? message : "n/a");
        buf.append(", cause: ");
        buf.append(cause != null ? ExceptionFormatter.format(cause) : "n/a");
        return buf.toString();
    }

    public boolean isClosing() {
        return this.closing;
    }

    protected void onConnectionError(ChannelHandlerContext ctx, Throwable cause, Http2Exception http2Ex) {
        if (this.handlingConnectionError) {
            return;
        }
        this.handlingConnectionError = true;
        if (http2Ex == null) {
            http2Ex = new Http2Exception(Http2Error.INTERNAL_ERROR, AbstractHttp2ConnectionHandler.goAwayDebugData(null, cause), cause);
        } else if (http2Ex instanceof Http2Exception.ClosedStreamCreationException) {
            Http2Exception.ClosedStreamCreationException e = (Http2Exception.ClosedStreamCreationException)http2Ex;
            http2Ex = new Http2Exception.ClosedStreamCreationException(e.error(), AbstractHttp2ConnectionHandler.goAwayDebugData((Http2Exception)e, cause), cause);
        } else {
            http2Ex = new Http2Exception(http2Ex.error(), AbstractHttp2ConnectionHandler.goAwayDebugData(http2Ex, cause), cause, http2Ex.shutdownHint());
        }
        super.onConnectionError(ctx, cause, http2Ex);
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        this.closing = true;
        this.connection().forEachActiveStream(closeAllStreams);
        this.onCloseRequest(ctx);
        super.close(ctx, promise);
    }

    protected abstract void onCloseRequest(ChannelHandlerContext var1) throws Exception;
}

