/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.internal.http;

import io.netty.handler.codec.DefaultHeaders;
import io.netty.handler.codec.Headers;
import io.netty.handler.codec.UnsupportedValueConverter;
import io.netty.handler.codec.ValueConverter;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.util.AsciiString;
import io.netty.util.HashingStrategy;
import io.netty.util.internal.StringUtil;
import java.net.URI;
import java.util.Iterator;
import java.util.Map;
import org.xbib.helianthus.common.http.HttpHeaderNames;
import org.xbib.helianthus.common.http.HttpMethod;
import org.xbib.helianthus.common.http.HttpStatus;
import org.xbib.helianthus.common.http.HttpStatusClass;

public final class HelianthusHttpUtil {
    public static final HashingStrategy<AsciiString> HTTP2_HEADER_NAME_HASHER = new HashingStrategy<AsciiString>(){

        public int hashCode(AsciiString o) {
            return o.hashCode();
        }

        public boolean equals(AsciiString a, AsciiString b) {
            return a.equals((Object)b);
        }
    };
    private static final CharSequenceMap HTTP_TO_HTTP2_HEADER_BLACKLIST = new CharSequenceMap();
    private static final CharSequenceMap HTTP2_TO_HTTP_HEADER_BLACKLIST = new CharSequenceMap();

    private HelianthusHttpUtil() {
    }

    public static boolean isContentAlwaysEmpty(HttpStatus status) {
        if (status.codeClass() == HttpStatusClass.INFORMATIONAL) {
            return true;
        }
        switch (status.code()) {
            case 204: 
            case 205: 
            case 304: {
                return true;
            }
        }
        return false;
    }

    public static org.xbib.helianthus.common.http.HttpHeaders toHelianthus(Http2Headers headers) {
        org.xbib.helianthus.common.http.DefaultHttpHeaders converted = new org.xbib.helianthus.common.http.DefaultHttpHeaders(false, headers.size());
        for (Map.Entry e : headers) {
            converted.add(AsciiString.of((CharSequence)((CharSequence)e.getKey())), ((CharSequence)e.getValue()).toString());
        }
        return converted;
    }

    public static org.xbib.helianthus.common.http.HttpHeaders toHelianthus(HttpMessage in) {
        HttpHeaders inHeaders = in.headers();
        org.xbib.helianthus.common.http.DefaultHttpHeaders out = new org.xbib.helianthus.common.http.DefaultHttpHeaders(true, inHeaders.size());
        if (in instanceof HttpRequest) {
            HttpRequest request = (HttpRequest)in;
            URI requestTargetUri = URI.create(request.uri());
            out.path(HelianthusHttpUtil.toHttp2Path(requestTargetUri));
            out.method(HttpMethod.valueOf(request.method().name()));
            HelianthusHttpUtil.setHttp2Scheme(inHeaders, requestTargetUri, out);
            if (!HttpUtil.isOriginForm((URI)requestTargetUri) && !HttpUtil.isAsteriskForm((URI)requestTargetUri)) {
                String host = inHeaders.getAsString((CharSequence)HttpHeaderNames.HOST);
                HelianthusHttpUtil.setHttp2Authority(host == null || host.isEmpty() ? requestTargetUri.getAuthority() : host, out);
            }
        } else if (in instanceof HttpResponse) {
            HttpResponse response = (HttpResponse)in;
            out.status(response.status().code());
        }
        HelianthusHttpUtil.toHelianthus(inHeaders, out);
        return out;
    }

    public static org.xbib.helianthus.common.http.HttpHeaders toHelianthus(HttpHeaders inHeaders) {
        if (inHeaders.isEmpty()) {
            return org.xbib.helianthus.common.http.HttpHeaders.EMPTY_HEADERS;
        }
        org.xbib.helianthus.common.http.DefaultHttpHeaders out = new org.xbib.helianthus.common.http.DefaultHttpHeaders(true, inHeaders.size());
        HelianthusHttpUtil.toHelianthus(inHeaders, out);
        return out;
    }

    public static void toHelianthus(HttpHeaders inHeaders, org.xbib.helianthus.common.http.HttpHeaders out) {
        Iterator i = inHeaders.iteratorCharSequence();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            AsciiString aName = AsciiString.of((CharSequence)((CharSequence)entry.getKey())).toLowerCase();
            if (HTTP_TO_HTTP2_HEADER_BLACKLIST.contains(aName) || aName.contentEqualsIgnoreCase((CharSequence)HttpHeaderNames.TE) && !AsciiString.contentEqualsIgnoreCase((CharSequence)((CharSequence)entry.getValue()), (CharSequence)HttpHeaderValues.TRAILERS)) continue;
            out.add(aName, ((CharSequence)entry.getValue()).toString());
        }
    }

    private static String toHttp2Path(URI uri) {
        StringBuilder pathBuilder = new StringBuilder(StringUtil.length((String)uri.getRawPath()) + StringUtil.length((String)uri.getRawQuery()) + StringUtil.length((String)uri.getRawFragment()) + 2);
        if (!StringUtil.isNullOrEmpty((String)uri.getRawPath())) {
            pathBuilder.append(uri.getRawPath());
        }
        if (!StringUtil.isNullOrEmpty((String)uri.getRawQuery())) {
            pathBuilder.append('?');
            pathBuilder.append(uri.getRawQuery());
        }
        if (!StringUtil.isNullOrEmpty((String)uri.getRawFragment())) {
            pathBuilder.append('#');
            pathBuilder.append(uri.getRawFragment());
        }
        return pathBuilder.toString();
    }

    private static void setHttp2Authority(String authority, org.xbib.helianthus.common.http.HttpHeaders out) {
        if (authority != null) {
            int endOfUserInfo = authority.indexOf(64);
            if (endOfUserInfo < 0) {
                out.authority(authority);
            } else if (endOfUserInfo + 1 < authority.length()) {
                out.authority(authority.substring(endOfUserInfo + 1));
            } else {
                throw new IllegalArgumentException("authority: " + authority);
            }
        }
    }

    private static void setHttp2Scheme(HttpHeaders in, URI uri, org.xbib.helianthus.common.http.HttpHeaders out) {
        String value = uri.getScheme();
        if (value != null) {
            out.scheme(value);
            return;
        }
        String cValue = in.get((CharSequence)HttpConversionUtil.ExtensionHeaderNames.SCHEME.text());
        if (cValue != null) {
            out.scheme(cValue.toString());
        } else {
            out.scheme("unknown");
        }
    }

    public static Http2Headers toNettyHttp2(org.xbib.helianthus.common.http.HttpHeaders inputHeaders) {
        DefaultHttp2Headers outputHeaders = new DefaultHttp2Headers(false, inputHeaders.size());
        outputHeaders.set((Headers)inputHeaders);
        outputHeaders.remove((Object)HttpHeaderNames.TRANSFER_ENCODING);
        outputHeaders.remove((Object)HttpHeaderNames.TRAILER);
        return outputHeaders;
    }

    public static HttpHeaders toNettyHttp1(org.xbib.helianthus.common.http.HttpHeaders inputHeaders) {
        DefaultHttpHeaders outputHeaders = new DefaultHttpHeaders();
        Iterator<Map.Entry<AsciiString, String>> iterator = inputHeaders.iterator();
        while (iterator.hasNext()) {
            Map.Entry<AsciiString, String> e = iterator.next();
            AsciiString name = e.getKey();
            if (name.isEmpty() || HTTP2_TO_HTTP_HEADER_BLACKLIST.contains(name)) continue;
            outputHeaders.add((CharSequence)name, (Object)e.getValue());
        }
        return outputHeaders;
    }

    public static void toNettyHttp1(int streamId, org.xbib.helianthus.common.http.HttpHeaders inputHeaders, HttpHeaders outputHeaders, HttpVersion httpVersion, boolean isTrailer, boolean isRequest) throws Http2Exception {
        Http2ToHttpHeaderTranslator translator = new Http2ToHttpHeaderTranslator(outputHeaders, isRequest);
        try {
            Iterator<Map.Entry<AsciiString, String>> iterator = inputHeaders.iterator();
            while (iterator.hasNext()) {
                Map.Entry<AsciiString, String> entry = iterator.next();
                translator.translate(entry);
            }
        }
        catch (Throwable t) {
            throw Http2Exception.streamError((int)streamId, (Http2Error)Http2Error.PROTOCOL_ERROR, (Throwable)t, (String)"HTTP/2 to HTTP/1.x headers conversion error", (Object[])new Object[0]);
        }
        outputHeaders.remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
        outputHeaders.remove((CharSequence)HttpHeaderNames.TRAILER);
        if (!isTrailer) {
            HttpUtil.setKeepAlive((HttpHeaders)outputHeaders, (HttpVersion)httpVersion, (boolean)true);
        }
    }

    static {
        HTTP_TO_HTTP2_HEADER_BLACKLIST.add(HttpHeaderNames.CONNECTION, AsciiString.EMPTY_STRING);
        AsciiString keepAlive = HttpHeaderNames.KEEP_ALIVE;
        HTTP_TO_HTTP2_HEADER_BLACKLIST.add(keepAlive, AsciiString.EMPTY_STRING);
        AsciiString proxyConnection = HttpHeaderNames.PROXY_CONNECTION;
        HTTP_TO_HTTP2_HEADER_BLACKLIST.add(proxyConnection, AsciiString.EMPTY_STRING);
        HTTP_TO_HTTP2_HEADER_BLACKLIST.add(HttpHeaderNames.TRANSFER_ENCODING, AsciiString.EMPTY_STRING);
        HTTP_TO_HTTP2_HEADER_BLACKLIST.add(HttpHeaderNames.HOST, AsciiString.EMPTY_STRING);
        HTTP_TO_HTTP2_HEADER_BLACKLIST.add(HttpHeaderNames.UPGRADE, AsciiString.EMPTY_STRING);
        HTTP_TO_HTTP2_HEADER_BLACKLIST.add(HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), AsciiString.EMPTY_STRING);
        HTTP_TO_HTTP2_HEADER_BLACKLIST.add(HttpConversionUtil.ExtensionHeaderNames.SCHEME.text(), AsciiString.EMPTY_STRING);
        HTTP_TO_HTTP2_HEADER_BLACKLIST.add(HttpConversionUtil.ExtensionHeaderNames.PATH.text(), AsciiString.EMPTY_STRING);
        HTTP2_TO_HTTP_HEADER_BLACKLIST.add(HttpHeaderNames.AUTHORITY, AsciiString.EMPTY_STRING);
        HTTP2_TO_HTTP_HEADER_BLACKLIST.add(HttpHeaderNames.METHOD, AsciiString.EMPTY_STRING);
        HTTP2_TO_HTTP_HEADER_BLACKLIST.add(HttpHeaderNames.PATH, AsciiString.EMPTY_STRING);
        HTTP2_TO_HTTP_HEADER_BLACKLIST.add(HttpHeaderNames.SCHEME, AsciiString.EMPTY_STRING);
        HTTP2_TO_HTTP_HEADER_BLACKLIST.add(HttpHeaderNames.STATUS, AsciiString.EMPTY_STRING);
        HTTP2_TO_HTTP_HEADER_BLACKLIST.add(HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), AsciiString.EMPTY_STRING);
        HTTP2_TO_HTTP_HEADER_BLACKLIST.add(HttpConversionUtil.ExtensionHeaderNames.SCHEME.text(), AsciiString.EMPTY_STRING);
        HTTP2_TO_HTTP_HEADER_BLACKLIST.add(HttpConversionUtil.ExtensionHeaderNames.PATH.text(), AsciiString.EMPTY_STRING);
    }

    private static final class CharSequenceMap
    extends DefaultHeaders<AsciiString, AsciiString, CharSequenceMap> {
        CharSequenceMap() {
            super(HTTP2_HEADER_NAME_HASHER, (ValueConverter)UnsupportedValueConverter.instance());
        }
    }

    private static final class Http2ToHttpHeaderTranslator {
        private static final CharSequenceMap REQUEST_HEADER_TRANSLATIONS = new CharSequenceMap();
        private static final CharSequenceMap RESPONSE_HEADER_TRANSLATIONS = new CharSequenceMap();
        private final HttpHeaders output;
        private final CharSequenceMap translations;

        Http2ToHttpHeaderTranslator(HttpHeaders output, boolean request) {
            this.output = output;
            this.translations = request ? REQUEST_HEADER_TRANSLATIONS : RESPONSE_HEADER_TRANSLATIONS;
        }

        public void translate(Map.Entry<AsciiString, String> entry) {
            AsciiString name = entry.getKey();
            String value = entry.getValue();
            AsciiString translatedName = (AsciiString)this.translations.get(name);
            if (translatedName != null) {
                this.output.add((CharSequence)translatedName, (Object)value);
                return;
            }
            if (name.isEmpty() || HTTP2_TO_HTTP_HEADER_BLACKLIST.contains(name)) {
                return;
            }
            if (HttpHeaderNames.COOKIE.equals((Object)name)) {
                String existingCookie = this.output.get((CharSequence)HttpHeaderNames.COOKIE);
                this.output.set((CharSequence)HttpHeaderNames.COOKIE, (Object)(existingCookie != null ? existingCookie + "; " + value : value));
            } else {
                this.output.add((CharSequence)name, (Object)value);
            }
        }

        static {
            RESPONSE_HEADER_TRANSLATIONS.add(Http2Headers.PseudoHeaderName.AUTHORITY.value(), HttpHeaderNames.HOST);
            RESPONSE_HEADER_TRANSLATIONS.add(Http2Headers.PseudoHeaderName.SCHEME.value(), HttpConversionUtil.ExtensionHeaderNames.SCHEME.text());
            REQUEST_HEADER_TRANSLATIONS.add((Headers)RESPONSE_HEADER_TRANSLATIONS);
            RESPONSE_HEADER_TRANSLATIONS.add(Http2Headers.PseudoHeaderName.PATH.value(), HttpConversionUtil.ExtensionHeaderNames.PATH.text());
        }
    }
}

