/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.internal.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.Queue;
import org.xbib.helianthus.common.ClosedSessionException;
import org.xbib.helianthus.common.http.HttpData;
import org.xbib.helianthus.common.http.HttpMethod;
import org.xbib.helianthus.common.http.HttpStatus;
import org.xbib.helianthus.common.http.HttpStatusClass;
import org.xbib.helianthus.common.stream.ClosedPublisherException;
import org.xbib.helianthus.internal.http.HelianthusHttpUtil;
import org.xbib.helianthus.internal.http.HttpObjectEncoder;

public final class Http1ObjectEncoder
extends HttpObjectEncoder {
    private final boolean server;
    private final IntObjectMap<PendingWrites> pendingWrites = new IntObjectHashMap();
    private int currentId = 1;
    private int minClosedId = Integer.MAX_VALUE;
    private int maxIdWithPendingWrites = Integer.MIN_VALUE;

    public Http1ObjectEncoder(boolean server) {
        this.server = server;
    }

    private static void setTransferEncoding(HttpMessage out) {
        HttpHeaders outHeaders = out.headers();
        long contentLength = HttpUtil.getContentLength((HttpMessage)out, (long)-1L);
        if (contentLength < 0L) {
            outHeaders.set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
            outHeaders.remove((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
        }
    }

    private static void flushPendingWrites(ChannelHandlerContext ctx, PendingWrites pendingWrites) {
        Map.Entry e;
        while ((e = (Map.Entry)pendingWrites.poll()) != null) {
            ctx.write(e.getKey(), (ChannelPromise)e.getValue());
        }
    }

    @Override
    protected ChannelFuture doWriteHeaders(ChannelHandlerContext ctx, int id, int streamId, org.xbib.helianthus.common.http.HttpHeaders headers, boolean endStream) {
        if (id >= this.minClosedId) {
            return ctx.newFailedFuture((Throwable)ClosedSessionException.get());
        }
        try {
            HttpObject converted = this.server ? this.convertServerHeaders(streamId, headers, endStream) : this.convertClientHeaders(streamId, headers);
            return this.write(ctx, id, converted, endStream);
        }
        catch (Throwable t) {
            return ctx.newFailedFuture(t);
        }
    }

    private HttpObject convertServerHeaders(int streamId, org.xbib.helianthus.common.http.HttpHeaders headers, boolean endStream) throws Http2Exception {
        DefaultFullHttpResponse res;
        boolean informational;
        HttpStatus status = headers.status();
        if (status == null) {
            return this.convertTrailingHeaders(streamId, headers);
        }
        boolean bl = informational = status.codeClass() == HttpStatusClass.INFORMATIONAL;
        if (endStream || informational) {
            res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status.toNettyStatus(), Unpooled.EMPTY_BUFFER, false);
            HttpHeaders outHeaders = res.headers();
            this.convert(streamId, headers, outHeaders, false);
            if (informational) {
                outHeaders.remove((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
            } else if (!headers.contains(HttpHeaderNames.CONTENT_LENGTH)) {
                outHeaders.setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, 0);
            }
        } else {
            res = new DefaultHttpResponse(HttpVersion.HTTP_1_1, status.toNettyStatus(), false);
            this.convert(streamId, headers, res.headers(), false);
            Http1ObjectEncoder.setTransferEncoding((HttpMessage)res);
        }
        return res;
    }

    private HttpObject convertClientHeaders(int streamId, org.xbib.helianthus.common.http.HttpHeaders headers) throws Http2Exception {
        HttpMethod method = headers.method();
        if (method == null) {
            return this.convertTrailingHeaders(streamId, headers);
        }
        DefaultHttpRequest req = new DefaultHttpRequest(HttpVersion.HTTP_1_1, method.toNettyMethod(), headers.path(), false);
        this.convert(streamId, headers, req.headers(), false);
        if (HttpUtil.getContentLength((HttpMessage)req, (long)-1L) >= 0L) {
            req.headers().remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
        } else {
            req.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
        }
        return req;
    }

    private void convert(int streamId, org.xbib.helianthus.common.http.HttpHeaders inHeaders, HttpHeaders outHeaders, boolean trailer) throws Http2Exception {
        HelianthusHttpUtil.toNettyHttp1(streamId, inHeaders, outHeaders, HttpVersion.HTTP_1_1, trailer, false);
        outHeaders.remove((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text());
        if (this.server) {
            outHeaders.remove((CharSequence)HttpConversionUtil.ExtensionHeaderNames.SCHEME.text());
        } else {
            outHeaders.remove((CharSequence)HttpConversionUtil.ExtensionHeaderNames.PATH.text());
        }
    }

    private LastHttpContent convertTrailingHeaders(int streamId, org.xbib.helianthus.common.http.HttpHeaders headers) throws Http2Exception {
        LastHttpContent lastContent;
        if (headers.isEmpty()) {
            lastContent = LastHttpContent.EMPTY_LAST_CONTENT;
        } else {
            lastContent = new DefaultLastHttpContent(Unpooled.EMPTY_BUFFER, false);
            this.convert(streamId, headers, lastContent.trailingHeaders(), true);
        }
        return lastContent;
    }

    @Override
    protected ChannelFuture doWriteData(ChannelHandlerContext ctx, int id, int streamId, HttpData data, boolean endStream) {
        if (id >= this.minClosedId) {
            return ctx.newFailedFuture((Throwable)ClosedSessionException.get());
        }
        try {
            ByteBuf buf = Http1ObjectEncoder.toByteBuf(ctx, data);
            Object content = endStream ? new DefaultLastHttpContent(buf) : new DefaultHttpContent(buf);
            return this.write(ctx, id, (HttpObject)content, endStream);
        }
        catch (Throwable t) {
            return ctx.newFailedFuture(t);
        }
    }

    private ChannelFuture write(ChannelHandlerContext ctx, int id, HttpObject obj, boolean endStream) {
        if (id < this.currentId) {
            return ctx.newFailedFuture((Throwable)ClosedPublisherException.get());
        }
        PendingWrites currentPendingWrites = (PendingWrites)this.pendingWrites.get(id);
        if (id == this.currentId) {
            if (currentPendingWrites != null) {
                this.pendingWrites.remove(id);
                Http1ObjectEncoder.flushPendingWrites(ctx, currentPendingWrites);
            }
            ChannelFuture future = ctx.write((Object)obj);
            if (endStream) {
                PendingWrites nextPendingWrites;
                ++this.currentId;
                while ((nextPendingWrites = (PendingWrites)this.pendingWrites.get(this.currentId)) != null) {
                    Http1ObjectEncoder.flushPendingWrites(ctx, nextPendingWrites);
                    if (!nextPendingWrites.isEndOfStream()) break;
                    this.pendingWrites.remove(this.currentId);
                    ++this.currentId;
                }
            }
            ctx.flush();
            return future;
        }
        ChannelPromise promise = ctx.newPromise();
        AbstractMap.SimpleImmutableEntry<HttpObject, ChannelPromise> entry = new AbstractMap.SimpleImmutableEntry<HttpObject, ChannelPromise>(obj, promise);
        if (currentPendingWrites == null) {
            PendingWrites newPendingWrites = new PendingWrites();
            this.maxIdWithPendingWrites = Math.max(this.maxIdWithPendingWrites, id);
            newPendingWrites.add(entry);
            this.pendingWrites.put(id, (Object)newPendingWrites);
        } else {
            currentPendingWrites.add(entry);
        }
        if (endStream) {
            currentPendingWrites.setEndOfStream();
        }
        return promise;
    }

    @Override
    protected ChannelFuture doWriteReset(ChannelHandlerContext ctx, int id, int streamId, Http2Error error) {
        for (int i = this.minClosedId = Math.min(this.minClosedId, id); i <= this.maxIdWithPendingWrites; ++i) {
            Map.Entry e;
            PendingWrites pendingWrites = (PendingWrites)this.pendingWrites.remove(i);
            while ((e = (Map.Entry)pendingWrites.poll()) != null) {
                ((ChannelPromise)e.getValue()).tryFailure((Throwable)ClosedSessionException.get());
            }
        }
        ChannelFuture f = ctx.write((Object)Unpooled.EMPTY_BUFFER);
        if (this.currentId >= this.minClosedId) {
            f.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
        return f;
    }

    @Override
    protected void doClose() {
        if (this.pendingWrites.isEmpty()) {
            return;
        }
        ClosedSessionException cause = ClosedSessionException.get();
        for (Queue queue : this.pendingWrites.values()) {
            Map.Entry e;
            while ((e = (Map.Entry)queue.poll()) != null) {
                ((ChannelPromise)e.getValue()).tryFailure((Throwable)cause);
            }
        }
        this.pendingWrites.clear();
    }

    private static final class PendingWrites
    extends ArrayDeque<Map.Entry<HttpObject, ChannelPromise>> {
        private static final long serialVersionUID = 4241891747461017445L;
        private boolean endOfStream;

        PendingWrites() {
            super(4);
        }

        boolean isEndOfStream() {
            return this.endOfStream;
        }

        void setEndOfStream() {
            this.endOfStream = true;
        }
    }
}

